/*
 * Decompiled with CFR 0.152.
 */
package com.animania.render.goats;

import com.animania.entities.goats.EntityAnimaniaGoat;
import com.animania.entities.goats.EntityBuckAngora;
import com.animania.models.goats.ModelBuckAngora;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBuckAngora<T extends EntityBuckAngora>
extends RenderLiving<T> {
    public static final Factory FACTORY = new Factory();
    private static final ResourceLocation goatTextures = new ResourceLocation("animania:textures/entity/goats/buck_angora.png");
    private static final ResourceLocation goatTexturesBlink = new ResourceLocation("animania:textures/entity/goats/buck_angora_blink.png");
    private static final ResourceLocation goatTexturesSheared = new ResourceLocation("animania:textures/entity/goats/buck_angora_sheared.png");
    private static final ResourceLocation goatTexturesShearedBlink = new ResourceLocation("animania:textures/entity/goats/buck_angora_sheared_blink.png");
    Random rand = new Random();

    public RenderBuckAngora(RenderManager rm) {
        super(rm, (ModelBase)new ModelBuckAngora(), 0.5f);
    }

    protected ResourceLocation getGoatTextures(T entity) {
        if (((EntityAnimaniaGoat)entity).func_70892_o()) {
            return goatTexturesSheared;
        }
        return goatTextures;
    }

    protected ResourceLocation getGoatTexturesBlink(T entity) {
        if (((EntityAnimaniaGoat)entity).func_70892_o()) {
            return goatTexturesShearedBlink;
        }
        return goatTexturesBlink;
    }

    protected void preRenderScale(EntityBuckAngora entity, float f) {
        GL11.glScalef((float)0.64f, (float)0.64f, (float)0.64f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.5f);
    }

    protected void preRenderCallback(T entityliving, float f) {
        this.preRenderScale((EntityBuckAngora)entityliving, f);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        int blinkTimer = ((EntityBuckAngora)entity).blinkTimer;
        if (blinkTimer < 7 && blinkTimer >= 0) {
            return this.getGoatTexturesBlink(entity);
        }
        return this.getGoatTextures(entity);
    }

    static class Factory<T extends EntityBuckAngora>
    implements IRenderFactory<T> {
        Factory() {
        }

        public Render<? super T> createRenderFor(RenderManager manager) {
            return new RenderBuckAngora(manager);
        }
    }
}

