/*
 * Decompiled with CFR 0.152.
 */
package com.animania.render.goats;

import com.animania.entities.goats.EntityKidKinder;
import com.animania.models.goats.ModelKidKinder;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderKidKinder<T extends EntityKidKinder>
extends RenderLiving<T> {
    public static final Factory FACTORY = new Factory();
    private static final ResourceLocation goatTextures = new ResourceLocation("animania:textures/entity/goats/kid_kinder.png");
    private static final ResourceLocation goatTexturesBlink = new ResourceLocation("animania:textures/entity/goats/kid_kinder_blink.png");
    Random rand = new Random();

    public RenderKidKinder(RenderManager rm) {
        super(rm, (ModelBase)new ModelKidKinder(), 0.5f);
    }

    protected ResourceLocation getGoatTextures(T par1Entity) {
        return goatTextures;
    }

    protected ResourceLocation getGoatTexturesBlink(T par1Entity) {
        return goatTexturesBlink;
    }

    protected void preRenderScale(EntityKidKinder entity, float f) {
        float age = entity.getEntityAge();
        GL11.glScalef((float)(0.27f + age), (float)(0.27f + age), (float)(0.27f + age));
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.5f);
    }

    protected void preRenderCallback(T entityliving, float f) {
        this.preRenderScale((EntityKidKinder)entityliving, f);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        int blinkTimer = ((EntityKidKinder)entity).blinkTimer;
        if (blinkTimer < 7 && blinkTimer >= 0) {
            return this.getGoatTexturesBlink(entity);
        }
        return this.getGoatTextures(entity);
    }

    static class Factory<T extends EntityKidKinder>
    implements IRenderFactory<T> {
        Factory() {
        }

        public Render<? super T> createRenderFor(RenderManager manager) {
            return new RenderKidKinder(manager);
        }
    }
}

