/*
 * Decompiled with CFR 0.152.
 */
package com.animania.render.rabbits;

import com.animania.entities.rodents.rabbits.EntityRabbitDoeChinchilla;
import com.animania.models.rabbits.ModelChinchilla;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderDoeChinchilla<T extends EntityRabbitDoeChinchilla>
extends RenderLiving<T> {
    public static final Factory FACTORY = new Factory();
    private static final ResourceLocation rabbitTextures = new ResourceLocation("animania:textures/entity/rabbits/rabbit_chinchilla.png");
    private static final ResourceLocation rabbitTexturesBlink = new ResourceLocation("animania:textures/entity/rabbits/rabbit_chinchilla_blink.png");
    Random rand = new Random();

    public RenderDoeChinchilla(RenderManager rm) {
        super(rm, (ModelBase)new ModelChinchilla(), 0.25f);
    }

    protected ResourceLocation getRabbitTextures(T par1EntityCow) {
        return rabbitTextures;
    }

    protected ResourceLocation getRabbitTexturesBlink(T par1EntityCow) {
        return rabbitTexturesBlink;
    }

    protected void preRenderScale(EntityRabbitDoeChinchilla entity, float f) {
        GL11.glScalef((float)0.59f, (float)0.59f, (float)0.59f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.5f);
    }

    protected void preRenderCallback(T entityliving, float f) {
        this.preRenderScale((EntityRabbitDoeChinchilla)entityliving, f);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        int blinkTimer = ((EntityRabbitDoeChinchilla)entity).blinkTimer;
        if (blinkTimer < 7 && blinkTimer >= 0) {
            return this.getRabbitTexturesBlink(entity);
        }
        return this.getRabbitTextures(entity);
    }

    static class Factory<T extends EntityRabbitDoeChinchilla>
    implements IRenderFactory<T> {
        Factory() {
        }

        public Render<? super T> createRenderFor(RenderManager manager) {
            return new RenderDoeChinchilla(manager);
        }
    }
}

