/*
 * Decompiled with CFR 0.152.
 */
package com.animania.render.rodents;

import com.animania.entities.rodents.EntityHedgehog;
import com.animania.models.ModelHedgehog;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHedgehog
extends RenderLiving<EntityHedgehog> {
    private static final ResourceLocation HEDGEHOG_TEXTURES = new ResourceLocation("animania:textures/entity/rodents/hedgehog.png");
    private static final ResourceLocation HEDGEHOG_TEXTURES_BLINK = new ResourceLocation("animania:textures/entity/rodents/hedgehog_blink.png");
    private static final ResourceLocation SONIC_TEXTURES = new ResourceLocation("animania:textures/entity/rodents/hedgehog_sonic.png");
    private static final ResourceLocation SANIC_TEXTURES = new ResourceLocation("animania:textures/entity/rodents/hedgehog_sanic.png");

    public RenderHedgehog(RenderManager rm) {
        super(rm, (ModelBase)new ModelHedgehog(), 0.3f);
    }

    protected void preRenderScale(EntityHedgehog entity, float f) {
        if (entity.func_184218_aH()) {
            if (entity.func_184187_bx() instanceof EntityPlayerSP) {
                GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
                EntityPlayer player = (EntityPlayer)entity.func_184187_bx();
                entity.field_70177_z = player.field_70177_z;
                if (player.func_70093_af()) {
                    GlStateManager.func_179109_b((float)-1.0f, (float)(entity.field_70131_O + 0.2f), (float)0.1f);
                } else {
                    GlStateManager.func_179109_b((float)-1.0f, (float)(entity.field_70131_O + 0.1f), (float)0.1f);
                }
            }
        } else if (entity.func_70906_o()) {
            GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)0.0f);
        } else {
            GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
            if (entity.func_95999_t().equals("Sanic")) {
                GL11.glRotatef((float)20.0f, (float)-1.0f, (float)0.0f, (float)1.0f);
                GL11.glScalef((float)1.2f, (float)1.7f, (float)1.6f);
            }
        }
    }

    protected void preRenderCallback(EntityHedgehog entityliving, float f) {
        this.preRenderScale(entityliving, f);
    }

    protected ResourceLocation getEntityTexture(EntityHedgehog entity) {
        if (entity.func_95999_t().equals("Sonic")) {
            return SONIC_TEXTURES;
        }
        if (entity.func_95999_t().equals("Sanic")) {
            return SANIC_TEXTURES;
        }
        int blinkTimer = entity.blinkTimer;
        if (blinkTimer < 5 && blinkTimer >= 0) {
            return HEDGEHOG_TEXTURES_BLINK;
        }
        return HEDGEHOG_TEXTURES;
    }

    public ModelHedgehog getMainModel() {
        return (ModelHedgehog)super.func_177087_b();
    }
}

