/*
 * Decompiled with CFR 0.152.
 */
package com.animania.tileentities;

import cofh.api.energy.IEnergyReceiver;
import com.animania.Animania;
import com.animania.AnimaniaHelper;
import com.animania.ModSoundEvents;
import com.animania.entities.rodents.EntityHamster;
import com.animania.tileentities.ItemHandlerHamsterWheel;
import com.leviathanstudio.craftstudio.CraftStudioApi;
import com.leviathanstudio.craftstudio.common.animation.AnimationHandler;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import com.leviathanstudio.craftstudio.common.animation.simpleImpl.AnimatedTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityHamsterWheel
extends AnimatedTileEntity
implements ITickable {
    private static AnimationHandler animHandler = CraftStudioApi.getNewAnimationHandler(TileEntityHamsterWheel.class);
    public boolean isRunning;
    private EntityHamster hamster;
    private NBTTagCompound hamsterNBT;
    private String hamsterName;
    private ItemHandlerHamsterWheel itemHandler = new ItemHandlerHamsterWheel();
    private int timer;
    private EnergyStorage power = new EnergyStorage(Animania.hamsterWheelCapacity);
    private int nbtSyncTimer;

    public void func_73660_a() {
        super.func_73660_a();
        if (this.hamster == null && this.hamsterNBT != null) {
            this.hamster = new EntityHamster(this.field_145850_b);
            this.hamster.func_70020_e(this.hamsterNBT);
            this.hamster.func_96094_a(this.hamsterName);
        }
        if (this.hamster != null) {
            this.isRunning = true;
            this.func_70296_d();
        } else {
            this.isRunning = false;
        }
        if (this.isRunning) {
            this.power.receiveEnergy(Animania.hamsterWheelRFGeneration, false);
            ++this.timer;
            this.func_70296_d();
        }
        if (this.timer >= Animania.hamsterWheelUseTime) {
            if (this.itemHandler.getStackInSlot(0) != null) {
                ItemStack stack = this.itemHandler.getStackInSlot(0).func_77946_l();
                --stack.field_77994_a;
                this.itemHandler.setStackInSlot(0, stack);
            } else {
                this.ejectHamster();
                this.isRunning = false;
            }
            this.timer = 0;
            this.func_70296_d();
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tile = this.getSurroundingTE(facing);
            if (tile != null) {
                IEnergyStorage energyStorage;
                int recieved;
                if (Loader.isModLoaded((String)"redstoneflux") && tile instanceof IEnergyReceiver) {
                    IEnergyReceiver reciever = (IEnergyReceiver)this.getSurroundingTE(facing);
                    recieved = reciever.receiveEnergy(facing.func_176734_d(), this.getEnergy(), false);
                    this.power.extractEnergy(recieved, false);
                } else if (tile.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()) && (energyStorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())).canReceive()) {
                    recieved = energyStorage.receiveEnergy(this.getEnergy(), false);
                    this.power.extractEnergy(recieved, false);
                }
            }
            this.func_70296_d();
        }
        this.updateAnims();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public EntityHamster getHamster() {
        return this.hamster;
    }

    public void setHamster(EntityHamster hamster) {
        this.hamster = hamster;
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public int getEnergy() {
        return this.power.getEnergyStored();
    }

    public void ejectHamster() {
        if (this.hamster != null && !this.field_145850_b.field_72995_K) {
            if (this.findPositionForHamster()) {
                this.field_145850_b.func_72838_d((Entity)this.hamster);
                Random rand = new Random();
                this.hamster.func_184185_a(SoundEvents.field_187638_cR, 1.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
                this.hamster.setFed(false);
                this.hamster = null;
                this.hamsterNBT = null;
                if (this.hamsterName != null && this.hamsterName != "") {
                    this.hamster.func_96094_a(this.hamsterName);
                }
            } else {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ModSoundEvents.hamsterDeath, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                this.hamster = null;
                this.hamsterNBT = null;
            }
        }
    }

    public EnergyStorage getPower() {
        return this.power;
    }

    private boolean findPositionForHamster() {
        for (EnumFacing e : EnumFacing.field_82609_l) {
            BlockPos pos = this.field_174879_c;
            IBlockState state = this.field_145850_b.func_180495_p(pos = pos.func_177972_a(e));
            if (state.func_185914_p() || state.func_185917_h() || state.func_177230_c() == Animania.blockHamsterWheel) continue;
            this.hamster.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            return true;
        }
        return false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tag = super.func_189515_b(compound);
        tag.func_74768_a("energy", this.power.getEnergyStored());
        tag.func_74757_a("running", this.isRunning);
        tag.func_74768_a("timer", this.timer);
        NBTTagCompound hamster = new NBTTagCompound();
        NBTTagCompound items = this.itemHandler.serializeNBT();
        tag.func_74782_a("hamster", (NBTBase)(this.hamster == null ? hamster : this.hamster.func_189511_e(hamster)));
        tag.func_74782_a("items", (NBTBase)items);
        return tag;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.power = new EnergyStorage(Animania.hamsterWheelCapacity);
        this.power.receiveEnergy(compound.func_74762_e("energy"), false);
        NBTTagCompound hamster = compound.func_74775_l("hamster");
        if (!hamster.equals((Object)new NBTTagCompound())) {
            this.hamsterNBT = hamster;
        } else {
            this.hamsterNBT = null;
            this.hamster = null;
        }
        this.isRunning = compound.func_74767_n("running");
        this.timer = compound.func_74762_e("timer");
        this.itemHandler.deserializeNBT(compound.func_74775_l("items"));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        if (this.field_145854_h != null && this.field_174879_c != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145854_h.func_176223_P(), this.field_145854_h.func_176223_P(), 1);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_189515_b(tagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    private TileEntity getSurroundingTE(EnumFacing facing) {
        BlockPos pos = this.field_174879_c.func_177972_a(facing);
        return this.field_145850_b.func_175625_s(pos);
    }

    public ItemHandlerHamsterWheel getItemHandler() {
        return this.itemHandler;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.itemHandler);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.power;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        ++this.nbtSyncTimer;
        if (this.nbtSyncTimer > 50) {
            super.func_70296_d();
            AnimaniaHelper.sendTileEntityUpdate((TileEntity)this);
            this.nbtSyncTimer = 0;
        }
    }

    public AnimationHandler<TileEntityHamsterWheel> getAnimationHandler() {
        return animHandler;
    }

    private void updateAnims() {
        if (this.isWorldRemote()) {
            if (this.isRunning && !this.getAnimationHandler().isAnimationActive("animania", "anim_hamster_wheel", (IAnimated)this)) {
                this.getAnimationHandler().clientStartAnimation("animania", "anim_hamster_wheel", (IAnimated)this);
                this.getAnimationHandler().clientStartAnimation("animania", "hamster_run", (IAnimated)this);
            } else if (!this.isRunning && this.getAnimationHandler().isAnimationActive("animania", "anim_hamster_wheel", (IAnimated)this)) {
                this.getAnimationHandler().clientStopAnimation("animania", "anim_hamster_wheel", (IAnimated)this);
                this.getAnimationHandler().clientStopAnimation("animania", "hamster_run", (IAnimated)this);
            }
        }
    }

    static {
        animHandler.addAnim("animania", "anim_hamster_wheel", "model_hamster_wheel", true);
        animHandler.addAnim("animania", "hamster_run", "hamster", true);
    }
}

