/*
 * Decompiled with CFR 0.152.
 */
package com.animania.client.render.cows;

import com.animania.client.models.ModelCalf;
import com.animania.common.entities.cows.EntityCalfBase;
import com.animania.common.entities.cows.EntityCalfFriesian;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderCalfFriesian<T extends EntityCalfFriesian>
extends RenderLiving<T> {
    public static final Factory FACTORY = new Factory();
    private static final ResourceLocation cowTextures = new ResourceLocation("animania:textures/entity/cows/calf_friesian.png");
    private static final ResourceLocation cowTexturesBlink = new ResourceLocation("animania:textures/entity/cows/calf_friesian_blink.png");
    private static final ResourceLocation purpTextures = new ResourceLocation("animania:textures/entity/cows/calf_purplicious.png");
    private static final ResourceLocation purpTexturesBlink = new ResourceLocation("animania:textures/entity/cows/calf_purplicious.png");
    Random rand = new Random();

    public RenderCalfFriesian(RenderManager rm) {
        super(rm, (ModelBase)new ModelCalf(), 0.5f);
    }

    protected ResourceLocation getCowTextures(T par1EntityCow) {
        if (par1EntityCow.func_95999_t().equals("Purp")) {
            return purpTextures;
        }
        return cowTextures;
    }

    protected ResourceLocation getCowTexturesBlink(T par1EntityCow) {
        if (par1EntityCow.func_95999_t().equals("Purp")) {
            return purpTexturesBlink;
        }
        return cowTexturesBlink;
    }

    protected void preRenderCallback(T entityliving, float f) {
        this.preRenderScale(entityliving, f);
    }

    protected void preRenderScale(T entity, float f) {
        float age = ((EntityCalfBase)entity).getEntityAge();
        GL11.glScalef((float)(1.0f + age), (float)(1.0f + age), (float)(1.0f + age));
    }

    protected ResourceLocation getEntityTexture(T entity) {
        int blinkTimer = ((EntityCalfFriesian)entity).blinkTimer;
        if (blinkTimer < 7 && blinkTimer >= 0) {
            return this.getCowTexturesBlink(entity);
        }
        return this.getCowTextures(entity);
    }

    static class Factory<T extends EntityCalfFriesian>
    implements IRenderFactory<T> {
        Factory() {
        }

        public Render<? super T> createRenderFor(RenderManager manager) {
            return new RenderCalfFriesian(manager);
        }
    }
}

