/*
 * Decompiled with CFR 0.152.
 */
package com.animania.client.render.goats;

import com.animania.client.models.goats.ModelKidAngora;
import com.animania.common.entities.goats.EntityKidAngora;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderKidAngora<T extends EntityKidAngora>
extends RenderLiving<T> {
    public static final Factory FACTORY = new Factory();
    private static final ResourceLocation goatTextures = new ResourceLocation("animania:textures/entity/goats/kid_angora.png");
    private static final ResourceLocation goatTexturesBlink = new ResourceLocation("animania:textures/entity/goats/kid_angora_blink.png");
    Random rand = new Random();

    public RenderKidAngora(RenderManager rm) {
        super(rm, (ModelBase)new ModelKidAngora(), 0.5f);
    }

    protected ResourceLocation getGoatTextures(T par1Entity) {
        return goatTextures;
    }

    protected ResourceLocation getGoatTexturesBlink(T par1Entity) {
        return goatTexturesBlink;
    }

    protected void preRenderScale(EntityKidAngora entity, float f) {
        float age = entity.getEntityAge();
        GL11.glScalef((float)(0.3f + age), (float)(0.3f + age), (float)(0.3f + age));
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.5f);
    }

    protected void preRenderCallback(T entityliving, float f) {
        this.preRenderScale((EntityKidAngora)entityliving, f);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        int blinkTimer = ((EntityKidAngora)entity).blinkTimer;
        if (blinkTimer < 7 && blinkTimer >= 0) {
            return this.getGoatTexturesBlink(entity);
        }
        return this.getGoatTextures(entity);
    }

    static class Factory<T extends EntityKidAngora>
    implements IRenderFactory<T> {
        Factory() {
        }

        public Render<? super T> createRenderFor(RenderManager manager) {
            return new RenderKidAngora(manager);
        }
    }
}

