/*
 * Decompiled with CFR 0.152.
 */
package com.animania.client.render.horses;

import com.animania.client.models.ModelDraftHorseFoal;
import com.animania.common.entities.horses.EntityFoalDraftHorse;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderFoalDraftHorse<T extends EntityFoalDraftHorse>
extends RenderLiving<T> {
    public static final Factory FACTORY = new Factory();
    private static final String modid = "animania";
    private static final String horseBaseDir = "textures/entity/horses/";
    private static final ResourceLocation[] HORSE_TEXTURES = new ResourceLocation[]{new ResourceLocation("animania", "textures/entity/horses/draft_horse_black.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_bw1.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_bw2.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_grey.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_red.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_white.png")};
    private static final ResourceLocation[] HORSE_TEXTURES_BLINK = new ResourceLocation[]{new ResourceLocation("animania", "textures/entity/horses/draft_horse_black_blink.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_bw1_blink.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_bw2_blink.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_grey_blink.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_red_blink.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_white_blink.png")};

    public RenderFoalDraftHorse(RenderManager rm) {
        super(rm, (ModelBase)new ModelDraftHorseFoal(), 0.5f);
    }

    protected void preRenderScale(EntityFoalDraftHorse entity, float f) {
        float age = entity.getEntityAge();
        GL11.glScalef((float)(0.4f + age), (float)(0.4f + age), (float)(0.4f + age));
    }

    protected void preRenderCallback(EntityFoalDraftHorse entityliving, float f) {
        this.preRenderScale(entityliving, f);
    }

    protected ResourceLocation getEntityTexture(EntityFoalDraftHorse entity) {
        int blinkTimer = entity.blinkTimer;
        if (blinkTimer < 5 && blinkTimer >= 0) {
            return HORSE_TEXTURES_BLINK[entity.getColorNumber()];
        }
        return HORSE_TEXTURES[entity.getColorNumber()];
    }

    static class Factory<T extends EntityFoalDraftHorse>
    implements IRenderFactory<T> {
        Factory() {
        }

        public Render<? super T> createRenderFor(RenderManager manager) {
            return new RenderFoalDraftHorse(manager);
        }
    }
}

