/*
 * Decompiled with CFR 0.152.
 */
package com.animania.client.render.rabbits;

import com.animania.client.models.rabbits.ModelLop;
import com.animania.common.entities.rodents.rabbits.EntityAnimaniaRabbit;
import com.animania.common.entities.rodents.rabbits.EntityRabbitKitLop;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderKitLop<T extends EntityRabbitKitLop>
extends RenderLiving<T> {
    public static final Factory FACTORY = new Factory();
    private static final String modid = "animania";
    private static final String rabbitBaseDir = "textures/entity/rabbits/";
    private static final ResourceLocation[] RABBIT_TEXTURES = new ResourceLocation[]{new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_black.png"), new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_brown.png"), new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_golden.png"), new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_olive.png"), new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_patch_black.png"), new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_patch_brown.png"), new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_patch_grey.png")};
    private static final ResourceLocation[] RABBIT_TEXTURES_BLINK = new ResourceLocation[]{new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_black_blink.png"), new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_brown_blink.png"), new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_golden_blink.png"), new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_olive_blink.png"), new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_patch_black_blink.png"), new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_patch_brown_blink.png"), new ResourceLocation("animania", "textures/entity/rabbits/rabbit_lop_patch_grey_blink.png")};

    public RenderKitLop(RenderManager rm) {
        super(rm, (ModelBase)new ModelLop(), 0.25f);
    }

    protected void preRenderScale(EntityRabbitKitLop entity, float f) {
        float age = entity.getEntityAge();
        GL11.glScalef((float)(0.23f + age), (float)(0.23f + age), (float)(0.23f + age));
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.5f);
    }

    protected void preRenderCallback(T entityliving, float f) {
        this.preRenderScale((EntityRabbitKitLop)entityliving, f);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        int blinkTimer = ((EntityRabbitKitLop)entity).blinkTimer;
        if (blinkTimer < 7 && blinkTimer >= 0) {
            return RABBIT_TEXTURES_BLINK[((EntityAnimaniaRabbit)entity).getColorNumber()];
        }
        return RABBIT_TEXTURES[((EntityAnimaniaRabbit)entity).getColorNumber()];
    }

    static class Factory<T extends EntityRabbitKitLop>
    implements IRenderFactory<T> {
        Factory() {
        }

        public Render<? super T> createRenderFor(RenderManager manager) {
            return new RenderKitLop(manager);
        }
    }
}

