/*
 * Decompiled with CFR 0.152.
 */
package com.animania.client.render.sheep;

import com.animania.client.models.sheep.ModelMerinoEwe;
import com.animania.common.entities.sheep.EntityAnimaniaSheep;
import com.animania.common.entities.sheep.EntityLambMerino;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderLambMerino<T extends EntityLambMerino>
extends RenderLiving<T> {
    public static final Factory FACTORY = new Factory();
    private static final String modid = "animania";
    private static final String SheepBaseDir = "textures/entity/sheep/";
    private static final ResourceLocation[] SHEEP_TEXTURES = new ResourceLocation[]{new ResourceLocation("animania", "textures/entity/sheep/sheep_merino_white_ewe.png"), new ResourceLocation("animania", "textures/entity/sheep/sheep_merino_brown_ewe.png")};
    private static final ResourceLocation[] SHEEP_TEXTURES_BLINK = new ResourceLocation[]{new ResourceLocation("animania", "textures/entity/sheep/sheep_merino_white_ewe_blink.png"), new ResourceLocation("animania", "textures/entity/sheep/sheep_merino_brown_ewe_blink.png")};
    private static final ResourceLocation[] SHEEP_TEXTURES_SHEARED = new ResourceLocation[]{new ResourceLocation("animania", "textures/entity/sheep/sheep_merino_white_ewe_sheared.png"), new ResourceLocation("animania", "textures/entity/sheep/sheep_merino_brown_ewe_sheared.png")};
    private static final ResourceLocation[] SHEEP_TEXTURES_SHEARED_BLINK = new ResourceLocation[]{new ResourceLocation("animania", "textures/entity/sheep/sheep_merino_white_ewe_sheared_blink.png"), new ResourceLocation("animania", "textures/entity/sheep/sheep_merino_brown_ewe_sheared_blink.png")};

    public RenderLambMerino(RenderManager rm) {
        super(rm, (ModelBase)new ModelMerinoEwe(), 0.5f);
    }

    protected void preRenderScale(EntityLambMerino entity, float f) {
        float age = entity.getEntityAge();
        GL11.glScalef((float)(0.24f + age), (float)(0.24f + age), (float)(0.24f + age));
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.5f);
    }

    protected void preRenderCallback(T entityliving, float f) {
        this.preRenderScale((EntityLambMerino)entityliving, f);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        int blinkTimer = ((EntityLambMerino)entity).blinkTimer;
        if (!((EntityAnimaniaSheep)entity).func_70892_o()) {
            if (blinkTimer < 7 && blinkTimer >= 0) {
                return SHEEP_TEXTURES_BLINK[((EntityAnimaniaSheep)entity).getColorNumber()];
            }
            return SHEEP_TEXTURES[((EntityAnimaniaSheep)entity).getColorNumber()];
        }
        if (blinkTimer < 7 && blinkTimer >= 0) {
            return SHEEP_TEXTURES_SHEARED_BLINK[((EntityAnimaniaSheep)entity).getColorNumber()];
        }
        return SHEEP_TEXTURES_SHEARED[((EntityAnimaniaSheep)entity).getColorNumber()];
    }

    static class Factory<T extends EntityLambMerino>
    implements IRenderFactory<T> {
        Factory() {
        }

        public Render<? super T> createRenderFor(RenderManager manager) {
            return new RenderLambMerino(manager);
        }
    }
}

