/*
 * Decompiled with CFR 0.152.
 */
package com.animania.client.render.tileEntity;

import com.animania.client.models.ModelTrough;
import com.animania.common.tileentities.TileEntityTrough;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityTroughRenderer
extends TileEntitySpecialRenderer<TileEntityTrough> {
    private static final ResourceLocation TROUGH_EMPTY_TEXTURE = new ResourceLocation("animania:textures/entity/tileentities/block_trough.png");
    private static final ResourceLocation WHEAT = new ResourceLocation("animania:textures/entity/tileentities/wheat.png");
    public static TileEntityTroughRenderer instance;
    private final ModelTrough trough = new ModelTrough();

    public void renderTileEntityAt(TileEntityTrough te, double x, double y, double z, float partialTicks, int destroyStage) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(te.func_145832_p() & 7));
        this.renderTrough(te, (float)x, (float)y, (float)z, enumfacing, destroyStage, partialTicks);
    }

    public void func_147497_a(TileEntityRendererDispatcher rendererDispatcherIn) {
        super.func_147497_a(rendererDispatcherIn);
        instance = this;
    }

    public void renderTrough(TileEntityTrough te, float x, float y, float z, EnumFacing facing, int destroyStage, float animateTicks) {
        ItemStack stack;
        TextureAtlasSprite sprite;
        FluidStack fluid;
        ModelTrough modelbase = this.trough;
        if (destroyStage >= 0) {
            this.func_147499_a(TileEntitySpecialRenderer.field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)2.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        Float rot = Float.valueOf(0.0f);
        if (facing == EnumFacing.UP) {
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        } else {
            switch (facing) {
                case NORTH: {
                    GlStateManager.func_179137_b((double)((double)x + 1.5), (double)(y + 1.5f), (double)((double)z + 0.5));
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179137_b((double)((double)x - 0.5), (double)(y + 1.5f), (double)((double)z + 0.5));
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GlStateManager.func_179137_b((double)((double)x + 0.5), (double)(y + 1.5f), (double)((double)z - 0.5));
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                default: {
                    GlStateManager.func_179137_b((double)((double)x + 0.5), (double)(y + 1.5f), (double)((double)z + 1.5));
                    GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
        }
        float f = 0.0625f;
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179089_o();
        this.func_147499_a(TROUGH_EMPTY_TEXTURE);
        modelbase.func_78088_a(null, animateTicks, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179094_E();
        if (te.getTroughContent() == TileEntityTrough.TroughContent.LIQUID && (fluid = te.fluidHandler.getFluid()) != null) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getStill().toString());
            ResourceLocation loc = new ResourceLocation(fluid.getFluid().getStill().func_110624_b() + ":textures/" + fluid.getFluid().getStill().func_110623_a() + ".png");
            double multi = 0.34 * (1.0 - (double)fluid.amount / 1000.0);
            GlStateManager.func_179137_b((double)0.0, (double)multi, (double)0.0);
            this.func_147499_a(loc);
            this.trough.renderFluid(0.0625f, sprite.func_94216_b() * sprite.func_110970_k());
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        if (te.getTroughContent() == TileEntityTrough.TroughContent.FOOD && !(stack = te.itemHandler.getStackInSlot(0)).func_190926_b()) {
            this.func_147499_a(TROUGH_EMPTY_TEXTURE);
            if (stack.func_77973_b() == Items.field_151015_O) {
                this.trough.renderFeed(stack.func_190916_E(), new Color(160, 124, 89));
            } else {
                this.trough.renderFeed(stack.func_190916_E(), this.getAverageColor(stack));
            }
            sprite = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null).func_177554_e();
            if (stack.func_77973_b() == Items.field_151015_O) {
                this.func_147499_a(WHEAT);
            } else {
                this.func_147499_a(new ResourceLocation(sprite.func_94215_i().replace(":", ":textures/") + ".png"));
            }
            this.trough.renderFood(0.0625f, stack.func_190916_E());
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    public Color getAverageColor(ItemStack item) {
        BufferedImage image;
        try {
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175599_af().func_184393_a(item, null, null).func_177554_e();
            ResourceLocation loc = new ResourceLocation(sprite.func_94215_i().replace(":", ":textures/") + ".png");
            InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(loc).func_110527_b();
            image = ImageIO.read(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Color(0, 0, 0);
        }
        int[] texture = new int[image.getWidth() * image.getHeight() * 4];
        texture = image.getRaster().getPixels(image.getRaster().getMinX(), image.getRaster().getMinY(), image.getRaster().getWidth(), image.getRaster().getHeight(), texture);
        int r = 0;
        int g = 0;
        int b = 0;
        int rloops = 0;
        int gloops = 0;
        int bloops = 0;
        for (int i = 0; i < texture.length; ++i) {
            try {
                if ((float)i / 4.0f * 4.0f == (float)i && texture[i + 3] >= 255) {
                    r += texture[i];
                    ++rloops;
                }
                if ((float)(i - 1) / 4.0f * 4.0f == (float)(i - 1) && texture[i + 2] >= 255) {
                    g += texture[i];
                    ++gloops;
                }
                if ((float)(i - 2) / 4.0f * 4.0f != (float)(i - 2) || texture[i + 1] < 255) continue;
                b += texture[i];
                ++bloops;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            r /= rloops;
            g /= gloops;
            b /= bloops;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Color(r, g, b);
    }
}

