/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.blocks;

import com.animania.Animania;
import com.animania.common.handler.BlockHandler;
import com.animania.common.handler.ItemHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.tileentities.TileEntityCheeseMold;
import com.animania.compat.top.providers.TOPInfoProvider;
import com.animania.config.AnimaniaConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockCheeseMold
extends BlockContainer
implements TOPInfoProvider {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);

    public BlockCheeseMold() {
        super(Material.field_151575_d, MapColor.field_151663_o);
        this.setRegistryName("animania:cheese_mold");
        this.func_149663_c("animania_cheese_mold");
        this.func_149647_a(Animania.TabAnimaniaResources);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(0.9f);
        this.func_149752_b(1.2f);
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)new ResourceLocation("animania", "cheese_mold"));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.EMPTY)));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCheeseMold();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ItemHandler.cheeseMold);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntityCheeseMold te = (TileEntityCheeseMold)world.func_175625_s(pos);
        if (!world.field_72995_K) {
            if (!stack.func_190926_b() && te != null && (AnimaniaHelper.hasFluid(stack, BlockHandler.fluidMilkFriesian) || AnimaniaHelper.hasFluid(stack, BlockHandler.fluidMilkHolstein) || AnimaniaHelper.hasFluid(stack, BlockHandler.fluidMilkGoat) || AnimaniaHelper.hasFluid(stack, BlockHandler.fluidMilkSheep) || AnimaniaHelper.hasFluid(stack, BlockHandler.fluidMilkJersey) || AnimaniaHelper.hasFluid(stack, FluidRegistry.WATER) && !AnimaniaConfig.gameRules.disableSaltCreation) && te.getFluidHandler().getFluidAmount() == 0 && te.getItemHandler().getStackInSlot(0).func_190926_b()) {
                ItemStack subStack = stack.func_77946_l().func_77979_a(1);
                IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)subStack);
                te.getFluidHandler().fill(FluidUtil.getFluidContained((ItemStack)subStack), true);
                if (!player.func_184812_l_()) {
                    handler.drain(1000, true);
                    stack.func_190918_g(1);
                    ItemStack newStack = handler.getContainer();
                    AnimaniaHelper.addItem(player, newStack);
                    return true;
                }
            }
            if (te != null) {
                if (!te.getItemHandler().getStackInSlot(0).func_190926_b() && !player.func_70093_af()) {
                    player.field_71071_by.func_70441_a(te.getItemHandler().getStackInSlot(0));
                    return true;
                }
                if (player.func_70093_af()) {
                    int progress = te.getProgress();
                    if (te.getItemHandler().getStackInSlot(0).func_190926_b()) {
                        player.func_146105_b((ITextComponent)new TextComponentString((int)((float)progress / (float)AnimaniaConfig.gameRules.cheeseMaturityTime * 100.0f) + "%"), true);
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentString("100%"), true);
                    }
                    return true;
                }
            }
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityCheeseMold te = (TileEntityCheeseMold)worldIn.func_175625_s(pos);
        if (te != null) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)te.getItemHandler().getStackInSlot(0));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TileEntityCheeseMold) {
            TileEntityCheeseMold mold = (TileEntityCheeseMold)te;
            ItemStack stack = mold.getItemHandler().getStackInSlot(0);
            FluidStack fluid = mold.getFluidHandler().getFluid();
            int progress = mold.getProgress();
            probeInfo.text(I18n.func_74838_a((String)"text.waila.aging") + ":");
            if (stack.func_190926_b()) {
                probeInfo.progress((int)((float)progress / (float)AnimaniaConfig.gameRules.cheeseMaturityTime * 100.0f), 100, probeInfo.defaultProgressStyle().suffix("%"));
            } else {
                probeInfo.progress(100, 100, probeInfo.defaultProgressStyle().suffix("%"));
            }
            if (mode == ProbeMode.NORMAL) {
                if (!stack.func_190926_b()) {
                    probeInfo.horizontal();
                    probeInfo.item(stack);
                }
                if (fluid != null) {
                    ItemStack bucket = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)fluid.getFluid());
                    probeInfo.horizontal().item(bucket).text(fluid.getLocalizedName() + ", " + fluid.amount + "mB");
                }
            }
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        EMPTY(0, "empty"),
        HOLSTEIN_MILK(1, "holstein_milk"),
        HOLSTEIN_CHEESE(2, "holstein_cheese"),
        FRIESIAN_MILK(3, "friesian_milk"),
        FRIESIAN_CHEESE(4, "friesian_cheese"),
        GOAT_MILK(5, "goat_milk"),
        GOAT_CHEESE(6, "goat_cheese"),
        SHEEP_MILK(7, "sheep_milk"),
        SHEEP_CHEESE(8, "sheep_cheese"),
        WATER(9, "water"),
        SALT(10, "salt"),
        JERSEY_MILK(11, "jersey_milk"),
        JERSEY_CHEESE(12, "jersey_cheese");

        private static final EnumType[] META;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META.length) {
                meta = 0;
            }
            return META[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockstone$enumtype;
                EnumType.META[blockstone$enumtype.getMetadata()] = blockstone$enumtype = enumTypeArray[i];
            }
        }
    }
}

