/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.blocks;

import com.animania.Animania;
import com.animania.common.capabilities.CapabilityRefs;
import com.animania.common.capabilities.ICapabilityPlayer;
import com.animania.common.entities.rodents.EntityHamster;
import com.animania.common.handler.ItemHandler;
import com.animania.common.tileentities.TileEntityHamsterWheel;
import com.animania.compat.top.providers.TOPInfoProvider;
import java.util.List;
import java.util.Random;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockHamsterWheel
extends BlockContainer
implements TOPInfoProvider {
    private String name = "block_hamster_wheel";
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockHamsterWheel() {
        super(Material.field_151573_f, MapColor.field_151670_w);
        this.setRegistryName(new ResourceLocation("animania", this.name));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_149663_c("animania_" + this.name);
        this.func_149647_a(Animania.TabAnimaniaResources);
        this.func_149675_a(true);
        this.func_149711_c(1.4f);
        this.func_149752_b(3.4f);
        this.field_149783_u = true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityHamsterWheel();
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityHamsterWheel te = (TileEntityHamsterWheel)world.func_175625_s(pos);
        if (player.func_184207_aI() && !te.isRunning()) {
            List passengers = player.func_184188_bt();
            if (passengers.get(0) instanceof EntityHamster && ((EntityHamster)passengers.get(0)).getFed() && !((EntityHamster)passengers.get(0)).isInBall()) {
                if (player.hasCapability(CapabilityRefs.CAPS, null)) {
                    ((ICapabilityPlayer)player.getCapability(CapabilityRefs.CAPS, null)).setMounted(false);
                }
                EntityHamster hamster = (EntityHamster)passengers.get(0);
                NBTTagCompound hamsternbt = new NBTTagCompound();
                hamster.func_189511_e(hamsternbt);
                EntityHamster clone = new EntityHamster(world);
                clone.func_70020_e(hamsternbt);
                player.func_184226_ay();
                te.setHamster(clone);
                hamster.func_70106_y();
                te.func_70296_d();
                Random rand = new Random();
                player.func_184185_a(SoundEvents.field_187638_cR, 1.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
                return true;
            }
        } else if (!player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() == ItemHandler.hamsterFood) {
            ItemStack held = player.func_184586_b(hand);
            ItemStack remainder = te.getItemHandler().insertItem(0, new ItemStack(ItemHandler.hamsterFood), false);
            if (!player.func_184812_l_() && remainder.func_190926_b()) {
                held.func_190918_g(1);
            }
            return true;
        }
        if (!world.field_72995_K && player.func_70093_af() && hand == EnumHand.MAIN_HAND) {
            ItemStack food = te.getItemHandler().getStackInSlot(0);
            if (food.func_190926_b()) {
                player.func_146105_b((ITextComponent)new TextComponentString(te.getEnergy() + "/" + te.getMaxEnergyStored(null) + " RF"), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString(te.getEnergy() + "/" + te.getMaxEnergyStored(null) + " RF, " + food.func_190916_E() + " " + food.func_82833_r()), true);
            }
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityHamsterWheel te = (TileEntityHamsterWheel)worldIn.func_175625_s(pos);
        if (te != null) {
            te.ejectHamster();
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)te.getItemHandler().getStackInSlot(0));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntityHamsterWheel wheel;
        ItemStack food;
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TileEntityHamsterWheel && mode == ProbeMode.NORMAL && !(food = (wheel = (TileEntityHamsterWheel)te).getItemHandler().getStackInSlot(0)).func_190926_b()) {
            probeInfo.item(food);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntityHamsterWheel te = (TileEntityHamsterWheel)worldIn.func_175625_s(pos);
        if (te.getHamster() != null) {
            return 15;
        }
        return 0;
    }
}

