/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.blocks;

import com.animania.Animania;
import com.animania.common.entities.pigs.EntityAnimaniaPig;
import com.animania.common.helper.AnimaniaHelper;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMud
extends Block {
    protected static final AxisAlignedBB MUD_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.88, 1.0);
    private String name = "block_mud";

    public BlockMud() {
        super(Material.field_151595_p, MapColor.field_151650_B);
        this.func_149647_a(Animania.TabAnimaniaResources);
        this.setRegistryName(new ResourceLocation("animania", this.name));
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_149663_c("animania_" + this.name);
        this.field_149765_K = 0.6f;
        this.func_149672_a(SoundType.field_185859_l);
        this.func_149675_a(true);
    }

    public int func_149738_a(World worldIn) {
        return 20;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int damageDropped(int par1) {
        return par1;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return MUD_AABB;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.field_70159_w *= 0.2;
        entityIn.field_70179_y *= 0.2;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        entityIn.field_70159_w *= 0.2;
        entityIn.field_70179_y *= 0.2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        List<EntityAnimaniaPig> pigs = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaPig.class, 10.0, worldIn, pos);
        for (EntityAnimaniaPig pig : pigs) {
            boolean isMuddy = false;
            Float splashTimer = Float.valueOf(0.0f);
            splashTimer = pig.getSplashTimer();
            isMuddy = pig.getMuddy();
            if (!isMuddy || !((double)splashTimer.floatValue() > 0.0)) continue;
            double xt = pig.field_70165_t;
            double yt = pig.field_70163_u;
            double zt = pig.field_70161_v;
            int x1 = pos.func_177958_n();
            int y1 = pos.func_177956_o();
            int z1 = pos.func_177952_p();
            double x2 = xt - (double)x1;
            double y2 = yt - (double)y1;
            double z2 = zt - (double)z1;
            if (MathHelper.func_76130_a((int)((int)x2)) >= 1 || MathHelper.func_76130_a((int)((int)z2)) >= 1 || MathHelper.func_76130_a((int)((int)y2)) >= 1) continue;
            for (int kk = 0; kk < 8; ++kk) {
                worldIn.func_175688_a(EnumParticleTypes.BLOCK_CRACK, pig.field_70165_t + ((double)rand.nextFloat() - 0.5) * (double)pig.field_70130_N, pig.func_174813_aQ().field_72338_b + 0.5, pig.field_70161_v + ((double)rand.nextFloat() - 0.5) * (double)pig.field_70130_N, 4.0 * ((double)rand.nextFloat() - 0.5), 0.5, ((double)rand.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)stateIn)});
            }
        }
    }
}

