/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.blocks;

import com.animania.Animania;
import com.animania.common.handler.BlockHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.tileentities.TileEntityTrough;
import com.animania.compat.top.providers.TOPInfoProvider;
import com.animania.config.AnimaniaConfig;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockTrough
extends BlockContainer
implements TOPInfoProvider {
    private String name = "block_trough";
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)3);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.25, 2.0, 0.3, 0.75);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(-1.0, 0.0, 0.25, 1.0, 0.3, 0.75);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.25, 0.0, -1.0, 0.75, 0.3, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 0.3, 2.0);

    public BlockTrough() {
        super(Material.field_151575_d);
        this.setRegistryName(new ResourceLocation("animania", this.name));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_149663_c("animania_" + this.name);
        this.func_149647_a(Animania.TabAnimaniaResources);
        this.func_149675_a(true);
    }

    public int func_149738_a(World worldIn) {
        return 10;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        float f = worldIn.func_180494_b(pos).func_180626_a(pos);
        if (worldIn.func_72959_q().func_76939_a(f, pos.func_177956_o()) >= 0.15f && worldIn.func_72896_J() && worldIn.func_175672_r(pos).func_177956_o() == pos.func_177956_o() + 1) {
            TileEntityTrough te = (TileEntityTrough)worldIn.func_175625_s(pos);
            if (te.itemHandler.getStackInSlot(0).func_190926_b() && te.fluidHandler.getFluid() == null) {
                te.fluidHandler.fill(new FluidStack(FluidRegistry.WATER, 100), true);
            } else if (te.itemHandler.getStackInSlot(0).func_190926_b() && te.fluidHandler.getFluid().getFluid() == FluidRegistry.WATER && te.fluidHandler.getFluid().amount < 1000) {
                te.fluidHandler.fill(new FluidStack(FluidRegistry.WATER, 100), true);
            }
        }
    }

    public String func_149732_F() {
        return I18n.func_74838_a((String)"tile.animania_block_trough.name");
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileEntityTrough te = (TileEntityTrough)worldIn.func_175625_s(pos);
        if (entityIn != null && entityIn instanceof EntityItem && !worldIn.field_72995_K) {
            EntityItem entityitem = (EntityItem)entityIn;
            ItemStack stack = entityitem.func_92059_d();
            if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151015_O || BlockTrough.isModdedFoodItem(stack)) {
                ItemStack held;
                ItemStack remaining;
                if ((!te.itemHandler.getStackInSlot(0).func_190926_b() && te.itemHandler.getStackInSlot(0).func_190916_E() < 3 || te.itemHandler.getStackInSlot(0).func_190926_b() && te.fluidHandler.getFluid() == null) && !ItemStack.func_77989_b((ItemStack)(remaining = te.itemHandler.insertItem(0, held = stack.func_77946_l().func_77979_a(1), false)), (ItemStack)held)) {
                    stack.func_190918_g(1);
                }
            } else if (AnimaniaHelper.hasFluid(stack, FluidRegistry.WATER) && te.itemHandler.getStackInSlot(0).func_190926_b() && te.fluidHandler.getFluid() == null) {
                te.fluidHandler.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187624_K, SoundCategory.BLOCKS, 0.6f, 0.8f);
                IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
                handler.drain(1000, true);
                ItemStack newStack = handler.getContainer();
                entityitem.func_92058_a(newStack);
            } else if (AnimaniaHelper.hasFluid(stack, BlockHandler.fluidSlop) && te.itemHandler.getStackInSlot(0).func_190926_b() && te.fluidHandler.getFluid() == null) {
                te.fluidHandler.fill(new FluidStack(BlockHandler.fluidSlop, 1000), true);
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187884_fr, SoundCategory.BLOCKS, 0.6f, 0.8f);
                IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
                handler.drain(1000, true);
                ItemStack newStack = handler.getContainer();
                entityitem.func_92058_a(newStack);
            }
            worldIn.func_175666_e(this.findInvisiblock(worldIn, pos), BlockHandler.blockInvisiblock);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            default: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: 
        }
        return EAST_AABB;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        boolean flag;
        TileEntityTrough teChk = (TileEntityTrough)worldIn.func_175625_s(pos);
        if (teChk != null) {
            // empty if block
        }
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        BlockPos blockpos = pos.func_177978_c();
        boolean bl = flag = this.field_176227_L == worldIn.func_180495_p(blockpos);
        if (!flag) {
            worldIn.func_180501_a(pos, state, 3);
        }
        if (placer.func_174811_aO().toString() == "south") {
            BlockPos invisipos = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            worldIn.func_175656_a(invisipos, BlockHandler.blockInvisiblock.func_176223_P());
            TileEntityTrough te = (TileEntityTrough)worldIn.func_175625_s(pos);
            te.setTroughRotation(0);
        } else if (placer.func_174811_aO().toString() == "north") {
            BlockPos invisipos = new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            worldIn.func_175656_a(invisipos, BlockHandler.blockInvisiblock.func_176223_P());
            TileEntityTrough te = (TileEntityTrough)worldIn.func_175625_s(pos);
            te.setTroughRotation(1);
        } else if (placer.func_174811_aO().toString() == "east") {
            BlockPos invisipos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            worldIn.func_175656_a(invisipos, BlockHandler.blockInvisiblock.func_176223_P());
            TileEntityTrough te = (TileEntityTrough)worldIn.func_175625_s(pos);
            te.setTroughRotation(2);
        } else if (placer.func_174811_aO().toString() == "west") {
            BlockPos invisipos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            worldIn.func_175656_a(invisipos, BlockHandler.blockInvisiblock.func_176223_P());
            TileEntityTrough te = (TileEntityTrough)worldIn.func_175625_s(pos);
            te.setTroughRotation(3);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        EntityPlayer entityplayer = worldIn.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5.0, false);
        String dir = "";
        if (entityplayer != null) {
            dir = entityplayer.func_174811_aO().toString().trim();
        }
        BlockPos blockpos = pos.func_177976_e();
        BlockPos blockpos1 = pos.func_177974_f();
        BlockPos blockpos2 = pos.func_177978_c();
        BlockPos blockpos3 = pos.func_177968_d();
        if (dir.equals("north") && !worldIn.func_180495_p(blockpos).func_177230_c().func_176200_f((IBlockAccess)worldIn, blockpos)) {
            return false;
        }
        if (dir.equals("east") && !worldIn.func_180495_p(blockpos2).func_177230_c().func_176200_f((IBlockAccess)worldIn, blockpos2)) {
            return false;
        }
        if (dir.equals("south") && !worldIn.func_180495_p(blockpos1).func_177230_c().func_176200_f((IBlockAccess)worldIn, blockpos1)) {
            return false;
        }
        return !dir.equals("west") || worldIn.func_180495_p(blockpos3).func_177230_c().func_176200_f((IBlockAccess)worldIn, blockpos3);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTrough();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(BlockHandler.blockTrough, 1);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos invisipos;
        String dir = ((EnumFacing)state.func_177229_b((IProperty)FACING)).toString();
        if (dir == "south") {
            invisipos = new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            worldIn.func_175698_g(invisipos);
        } else if (dir == "north") {
            invisipos = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            worldIn.func_175698_g(invisipos);
        } else if (dir == "east") {
            invisipos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            worldIn.func_175698_g(invisipos);
        } else if (dir == "west") {
            invisipos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            worldIn.func_175698_g(invisipos);
        }
        TileEntityTrough te = (TileEntityTrough)worldIn.func_175625_s(pos);
        if (te != null) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)te.itemHandler.getStackInSlot(0));
        }
        Random rand = new Random();
        super.func_180663_b(worldIn, pos, state);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockHandler.blockTrough);
    }

    public boolean canDispenserPlace(World worldIn, BlockPos pos, ItemStack stack) {
        return stack.func_77960_j() == 1 && pos.func_177956_o() >= 2 && worldIn.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        TileEntityTrough te = (TileEntityTrough)worldIn.func_175625_s(pos);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Items.field_151015_O || BlockTrough.isModdedFoodItem(heldItem)) {
            if (!te.itemHandler.getStackInSlot(0).func_190926_b() && te.itemHandler.getStackInSlot(0).func_190916_E() < 3 || te.itemHandler.getStackInSlot(0).func_190926_b() && te.fluidHandler.getFluid() == null) {
                ItemStack held = heldItem.func_77946_l().func_77979_a(1);
                ItemStack remaining = te.itemHandler.insertItem(0, held, false);
                if (!playerIn.func_184812_l_() && !ItemStack.func_77989_b((ItemStack)remaining, (ItemStack)held)) {
                    heldItem.func_190918_g(1);
                }
                worldIn.func_175666_e(this.findInvisiblock(worldIn, pos), BlockHandler.blockInvisiblock);
                return true;
            }
        } else {
            if (AnimaniaHelper.hasFluid(heldItem, FluidRegistry.WATER) && te.itemHandler.getStackInSlot(0).func_190926_b() && te.fluidHandler.getFluid() == null) {
                te.fluidHandler.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187624_K, SoundCategory.PLAYERS, 0.6f, 0.8f);
                if (!playerIn.func_184812_l_()) {
                    IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)heldItem);
                    handler.drain(1000, true);
                    ItemStack newStack = handler.getContainer();
                    playerIn.func_184611_a(hand, newStack);
                }
                worldIn.func_175666_e(this.findInvisiblock(worldIn, pos), BlockHandler.blockInvisiblock);
                return true;
            }
            if (AnimaniaHelper.hasFluid(heldItem, FluidRegistry.WATER) && te.fluidHandler.getFluid() != null && te.fluidHandler.getFluid().getFluid() == FluidRegistry.WATER && te.fluidHandler.getFluid().amount < 1000) {
                te.fluidHandler.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187624_K, SoundCategory.PLAYERS, 0.6f, 0.8f);
                if (!playerIn.func_184812_l_()) {
                    IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)heldItem);
                    handler.drain(1000, true);
                    ItemStack newStack = handler.getContainer();
                    playerIn.func_184611_a(hand, newStack);
                }
                worldIn.func_175666_e(this.findInvisiblock(worldIn, pos), BlockHandler.blockInvisiblock);
                return true;
            }
            if (AnimaniaHelper.hasFluid(heldItem, BlockHandler.fluidSlop) && te.itemHandler.getStackInSlot(0).func_190926_b() && te.fluidHandler.getFluid() == null) {
                te.fluidHandler.fill(new FluidStack(BlockHandler.fluidSlop, 1000), true);
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187884_fr, SoundCategory.PLAYERS, 0.6f, 0.8f);
                if (!playerIn.func_184812_l_()) {
                    IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)heldItem);
                    handler.drain(1000, true);
                    ItemStack newStack = handler.getContainer();
                    playerIn.func_184611_a(hand, newStack);
                }
                worldIn.func_175666_e(this.findInvisiblock(worldIn, pos), BlockHandler.blockInvisiblock);
                return true;
            }
            if (AnimaniaHelper.hasFluid(heldItem, BlockHandler.fluidSlop) && te.fluidHandler.getFluid() != null && te.fluidHandler.getFluid().getFluid() == BlockHandler.fluidSlop && te.fluidHandler.getFluid().amount < 1000) {
                te.fluidHandler.fill(new FluidStack(BlockHandler.fluidSlop, 1000), true);
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187884_fr, SoundCategory.PLAYERS, 0.6f, 0.8f);
                if (!playerIn.func_184812_l_()) {
                    IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)heldItem);
                    handler.drain(1000, true);
                    ItemStack newStack = handler.getContainer();
                    playerIn.func_184611_a(hand, newStack);
                }
                worldIn.func_175666_e(this.findInvisiblock(worldIn, pos), BlockHandler.blockInvisiblock);
                return true;
            }
            if (playerIn.func_184592_cb().func_190926_b() && playerIn.func_184614_ca().func_190926_b() && !te.itemHandler.getStackInSlot(0).func_190926_b()) {
                ItemStack extract = te.itemHandler.extractItem(0, 1, false);
                playerIn.field_71071_by.func_70441_a(extract);
                worldIn.func_175666_e(this.findInvisiblock(worldIn, pos), BlockHandler.blockInvisiblock);
                return true;
            }
            if (!heldItem.func_190926_b() && FluidUtil.getFluidHandler((ItemStack)heldItem) != null && FluidUtil.getFluidContained((ItemStack)heldItem) == null && te.fluidHandler.getFluid() != null && te.fluidHandler.getFluid().amount >= 1000) {
                FluidStack fluidStack = te.fluidHandler.drain(1000, true);
                if (!playerIn.func_184812_l_() && heldItem.func_190916_E() >= 1) {
                    ItemStack heldItem1 = heldItem.func_77946_l();
                    heldItem1.func_190920_e(1);
                    IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)heldItem1);
                    handler.fill(fluidStack, true);
                    ItemStack newstack = handler.getContainer();
                    if (heldItem.func_190916_E() > 1) {
                        heldItem.func_190918_g(1);
                        playerIn.field_71071_by.func_70441_a(newstack);
                    } else {
                        playerIn.func_184611_a(hand, newstack);
                    }
                    return true;
                }
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187630_M, SoundCategory.PLAYERS, 0.6f, 0.8f);
                worldIn.func_175666_e(this.findInvisiblock(worldIn, pos), BlockHandler.blockInvisiblock);
                return true;
            }
        }
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntityTrough te = (TileEntityTrough)worldIn.func_175625_s(pos);
        if (!te.itemHandler.getStackInSlot(0).func_190926_b()) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)te.itemHandler);
        }
        if (te.fluidHandler.getFluid() != null) {
            int fluid = te.fluidHandler.getFluidAmount();
            return fluid / 66;
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public BlockPos findInvisiblock(World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        facing = facing.func_176732_a(EnumFacing.Axis.Y);
        return pos.func_177972_a(facing);
    }

    public static boolean isModdedFoodItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        String[] foods = AnimaniaConfig.gameRules.troughFood;
        for (int i = 0; i < foods.length; ++i) {
            if (!ItemStack.func_179545_c((ItemStack)AnimaniaHelper.getItem(foods[i]), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        BlockPos invisi = this.findInvisiblock(worldIn, pos);
        worldIn.func_175666_e(invisi, BlockHandler.blockInvisiblock);
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TileEntityTrough) {
            TileEntityTrough trough = (TileEntityTrough)te;
            ItemStack stack = trough.itemHandler.getStackInSlot(0);
            FluidStack fluid = trough.fluidHandler.getFluid();
            if (mode == ProbeMode.NORMAL) {
                if (!stack.func_190926_b()) {
                    probeInfo.horizontal();
                    probeInfo.item(stack);
                }
                if (fluid != null) {
                    ItemStack bucket = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)fluid.getFluid());
                    probeInfo.horizontal().item(bucket).text(fluid.getLocalizedName() + ", " + fluid.amount + "mB");
                }
            }
        }
    }
}

