/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.amphibians;

import com.animania.common.ModSoundEvents;
import com.animania.common.entities.AnimalContainer;
import com.animania.common.entities.EntityGender;
import com.animania.common.entities.amphibians.AmphibianType;
import com.animania.common.entities.amphibians.EntityAmphibian;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.config.AnimaniaConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityDartFrogs
extends EntityAmphibian {
    private static final DataParameter<Integer> FROGS_TYPE = EntityDataManager.func_187226_a(EntityDartFrogs.class, (DataSerializer)DataSerializers.field_187192_b);
    public int poisonTimer = 2;
    private int jumpTicks;
    private int jumpDuration;
    private boolean canEntityJump;

    public EntityDartFrogs(World worldIn) {
        super(worldIn, true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FROGS_TYPE, (Object)this.field_70146_Z.nextInt(3));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("FrogsType", this.getFrogsType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFrogsType(compound.func_74762_e("FrogsType"));
    }

    public int getFrogsType() {
        return (Integer)this.field_70180_af.func_187225_a(FROGS_TYPE);
    }

    public void setFrogsType(int frogsId) {
        this.field_70180_af.func_187227_b(FROGS_TYPE, (Object)frogsId);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151032_g && this.poisonTimer <= 1) {
            this.poisonTimer = 800;
            player.func_184185_a(SoundEvents.field_187764_dj, 0.2f, 1.8f);
            ItemStack bob = new ItemStack(Items.field_185167_i);
            PotionUtils.func_185188_a((ItemStack)bob, (PotionType)PotionTypes.field_185254_z);
            stack.func_190918_g(1);
            if (stack.func_190916_E() == 0) {
                player.func_184611_a(hand, bob);
                return true;
            }
            if (!player.field_71071_by.func_70441_a(bob)) {
                player.func_71019_a(bob, false);
                return true;
            }
            return super.func_184645_a(player, hand);
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof EntityPlayer && entityIn != this) {
            EntityPlayer player = (EntityPlayer)entityIn;
            player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 1, false, false));
        }
        entityIn.func_70108_f((Entity)this);
    }

    @Override
    public void func_70636_d() {
        if (this.poisonTimer > 1) {
            --this.poisonTimer;
        }
        if (this.canEntityJump) {
            if (this.jumpTicks != this.jumpDuration) {
                ++this.jumpTicks;
            } else if (this.jumpDuration != 0) {
                this.jumpTicks = 0;
                this.jumpDuration = 0;
                this.func_70637_d(false);
            }
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70636_d();
        if (this.field_70122_E) {
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E) {
            this.squishAmount = 0.5f;
        }
        this.alterSquishAmount();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setFrogsType(this.field_70146_Z.nextInt(3));
        return livingdata;
    }

    @Override
    protected SoundEvent func_184639_G() {
        Random rand = new Random();
        int chooser = rand.nextInt(5);
        if (chooser == 0) {
            return ModSoundEvents.dartfrogLiving1;
        }
        if (chooser == 1) {
            return ModSoundEvents.dartfrogLiving2;
        }
        if (chooser == 2) {
            return ModSoundEvents.dartfrogLiving3;
        }
        if (chooser == 3) {
            return ModSoundEvents.dartfrogLiving4;
        }
        return null;
    }

    @Override
    protected SoundEvent func_184601_bQ() {
        return null;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - (float)(this.func_70654_ax() * 2));
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.04f, 1.1f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected void func_70628_a(boolean hit, int lootlevel) {
        String drop2;
        ItemStack dropItem2;
        String drop = AnimaniaConfig.drops.dartFrogDrop;
        ItemStack dropItem = AnimaniaHelper.getItem(drop);
        if (dropItem != null) {
            dropItem.func_190920_e(1 + lootlevel);
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, dropItem);
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
        if ((dropItem2 = AnimaniaHelper.getItem(drop2 = AnimaniaConfig.drops.dartFrogDrop2)) != null) {
            this.func_145779_a(dropItem2.func_77973_b(), AnimaniaConfig.drops.dartFrogDrop2Amount + lootlevel);
        }
    }

    private ItemStack getItem(String moditem) {
        Item bob;
        ItemStack foundStack = null;
        String item = "";
        String mod = "";
        int sepLoc = 0;
        int metaLoc = 0;
        boolean metaFlag = false;
        String metaVal = "";
        sepLoc = moditem.indexOf(":");
        metaLoc = moditem.indexOf("#");
        if (!moditem.contains(":")) {
            return new ItemStack(Blocks.field_150350_a, 1);
        }
        mod = moditem.substring(0, sepLoc);
        item = metaLoc > 0 ? moditem.substring(sepLoc + 1, metaLoc) : moditem.substring(sepLoc + 1, moditem.length());
        if (metaLoc > 0) {
            metaFlag = true;
            metaVal = moditem.substring(metaLoc + 1, moditem.length());
        }
        foundStack = (bob = Item.func_111206_d((String)item)) != null ? (metaFlag ? new ItemStack(bob, 1, Integer.parseInt(metaVal)) : new ItemStack(bob, 1)) : new ItemStack(Blocks.field_150350_a, 1);
        return foundStack;
    }

    @Override
    public Item getSpawnEgg() {
        return ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(AmphibianType.DART_FROG, EntityGender.NONE));
    }

    @Override
    public boolean usesEggColor() {
        return false;
    }
}

