/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.horses;

import com.animania.common.ModSoundEvents;
import com.animania.common.entities.EntityGender;
import com.animania.common.entities.horses.EntityAnimaniaHorse;
import com.animania.common.entities.horses.EntityFoalBase;
import com.animania.common.entities.horses.EntityFoalDraftHorse;
import com.animania.common.entities.horses.EntityStallionBase;
import com.animania.common.entities.horses.EntityStallionDraftHorse;
import com.animania.common.entities.horses.HorseType;
import com.animania.common.entities.horses.ai.EntityAIPanicHorses;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.compat.top.providers.entity.TOPInfoProviderMateable;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMareBase
extends EntityAnimaniaHorse
implements TOPInfoProviderMateable {
    private ResourceLocation resourceLocation;
    private ResourceLocation resourceLocationBlink;
    private static final String[] HORSE_TEXTURES = new String[]{"black", "bw1", "bw2", "grey", "red", "white"};
    private boolean boosting;
    private int boostTime;
    private int totalBoostTime;
    public int dryTimerMare;
    protected static final DataParameter<Boolean> PREGNANT = EntityDataManager.func_187226_a(EntityMareBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HAS_FOALS = EntityDataManager.func_187226_a(EntityMareBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FERTILE = EntityDataManager.func_187226_a(EntityMareBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> GESTATION_TIMER = EntityDataManager.func_187226_a(EntityMareBase.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityMareBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.6f, 2.2f);
        this.field_70138_W = 1.2f;
        this.mateable = true;
        this.gender = EntityGender.FEMALE;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PREGNANT, (Object)false);
        this.field_70180_af.func_187214_a(HAS_FOALS, (Object)false);
        this.field_70180_af.func_187214_a(FERTILE, (Object)true);
        this.field_70180_af.func_187214_a(GESTATION_TIMER, (Object)(AnimaniaConfig.careAndFeeding.gestationTimer + this.field_70146_Z.nextInt(400)));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPanicHorses((EntityCreature)this, 2.0));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        List list = this.field_70170_p.field_72996_f;
        int currentCount = 0;
        int num = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof EntityAnimaniaHorse)) continue;
            ++num;
        }
        currentCount = num;
        if (currentCount <= AnimaniaConfig.spawn.spawnLimitHorses) {
            int chooser = this.field_70146_Z.nextInt(5);
            if (chooser == 0) {
                EntityStallionDraftHorse entityHorse = new EntityStallionDraftHorse(this.field_70170_p);
                entityHorse.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityHorse);
                entityHorse.setMateUniqueId(this.field_96093_i);
                this.setMateUniqueId(entityHorse.getPersistentID());
            } else if (chooser == 1 && !AnimaniaConfig.careAndFeeding.manualBreeding) {
                EntityFoalDraftHorse entityHorse = new EntityFoalDraftHorse(this.field_70170_p);
                entityHorse.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityHorse);
                entityHorse.setParentUniqueId(this.field_96093_i);
            } else if (chooser > 2) {
                EntityStallionDraftHorse entityHorse = new EntityStallionDraftHorse(this.field_70170_p);
                entityHorse.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityHorse);
                entityHorse.setMateUniqueId(this.field_96093_i);
                this.setMateUniqueId(entityHorse.getPersistentID());
                if (!AnimaniaConfig.careAndFeeding.manualBreeding) {
                    EntityFoalDraftHorse entityFoal = new EntityFoalDraftHorse(this.field_70170_p);
                    entityFoal.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)entityFoal);
                    entityFoal.setParentUniqueId(this.field_96093_i);
                }
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        if (this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184641_n(true);
        } else {
            this.func_184641_n(false);
        }
        return livingdata;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Pregnant", this.getPregnant());
        compound.func_74757_a("HasKids", this.getHasKids());
        compound.func_74757_a("Fertile", this.getFertile());
        compound.func_74768_a("Gestation", this.getGestation());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setPregnant(compound.func_74767_n("Pregnant"));
        this.setHasKids(compound.func_74767_n("HasKids"));
        this.setFertile(compound.func_74767_n("Fertile"));
        this.setGestation(compound.func_74762_e("Gestation"));
    }

    public int getGestation() {
        try {
            return this.getIntFromDataManager(GESTATION_TIMER);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setGestation(int gestation) {
        this.field_70180_af.func_187227_b(GESTATION_TIMER, (Object)gestation);
    }

    public boolean getPregnant() {
        try {
            return this.getBoolFromDataManager(PREGNANT);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setPregnant(boolean preggers) {
        if (preggers) {
            this.setGestation(AnimaniaConfig.careAndFeeding.gestationTimer + this.field_70146_Z.nextInt(200));
        }
        this.field_70180_af.func_187227_b(PREGNANT, (Object)preggers);
    }

    public boolean getFertile() {
        try {
            return this.getBoolFromDataManager(FERTILE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFertile(boolean fertile) {
        this.field_70180_af.func_187227_b(FERTILE, (Object)fertile);
    }

    public boolean getHasKids() {
        try {
            return this.getBoolFromDataManager(HAS_FOALS);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setHasKids(boolean Foals) {
        this.field_70180_af.func_187227_b(HAS_FOALS, (Object)Foals);
    }

    @Override
    @Nullable
    public UUID getMateUniqueId() {
        try {
            UUID id = (UUID)((Optional)this.field_70180_af.func_187225_a(MATE_UNIQUE_ID)).orNull();
            return id;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setMateUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(MATE_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.6;
    }

    public void func_110199_f(EntityPlayer playerEntity) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            this.field_110296_bG.func_110133_a(this.func_70005_c_());
            playerEntity.func_184826_a((AbstractHorse)this, (IInventory)this.field_110296_bG);
        }
    }

    public int func_70646_bf() {
        return super.func_70646_bf();
    }

    public boolean boost() {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.totalBoostTime = this.func_70681_au().nextInt(841) + 140;
        return true;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        return this.func_110257_ck();
    }

    @Override
    public void func_70612_e(float strafe, float forward) {
        Entity entity;
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (this.func_110257_ck() && this.func_184207_aI() && this.func_82171_bF()) {
            this.field_70126_B = this.field_70177_z = entity.field_70177_z;
            this.field_70125_A = entity.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.7f;
                if (this.boosting) {
                    if (this.boostTime++ > this.totalBoostTime) {
                        this.boosting = false;
                    }
                    f += f * 1.15f * MathHelper.func_76126_a((float)((float)this.boostTime / (float)this.totalBoostTime * (float)Math.PI));
                }
                this.func_70659_e(f);
                super.func_70612_e(0.0f, 1.0f);
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 1.0f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187729_cv, 0.2f, 0.8f);
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 1;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 18 : (happy == 1 ? 36 : 60))) == 0) {
            return ModSoundEvents.horseliving1;
        }
        if (chooser == 1) {
            return ModSoundEvents.horseliving2;
        }
        if (chooser == 2) {
            return ModSoundEvents.horseliving3;
        }
        if (chooser == 3) {
            return ModSoundEvents.horseliving4;
        }
        if (chooser == 4) {
            return ModSoundEvents.horseliving5;
        }
        return ModSoundEvents.horseliving6;
    }

    protected SoundEvent func_184601_bQ() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.horsehurt1;
        }
        if (chooser == 1) {
            return ModSoundEvents.horsehurt2;
        }
        return ModSoundEvents.horsehurt3;
    }

    protected SoundEvent func_184615_bR() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.horsehurt1;
        }
        if (chooser == 1) {
            return ModSoundEvents.horsehurt2;
        }
        return ModSoundEvents.horsehurt3;
    }

    @Override
    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - 0.05f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.func_184207_aI()) {
            return 0.0f;
        }
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 156 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 160) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.func_184207_aI()) {
            return 0.0f;
        }
        if (this.eatTimer > 4 && this.eatTimer <= 156) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 80.0f;
            return 0.62831855f + 0.0439823f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public ResourceLocation getResourceLocationBlink() {
        return this.resourceLocationBlink;
    }

    public void func_70636_d() {
        int gestationTimer;
        if (this.getAnimalAge() == 0) {
            this.setAnimalAge(1);
        }
        if (this.func_184207_aI() && !this.func_175446_cd()) {
            this.func_94061_f(true);
        } else {
            this.func_94061_f(false);
        }
        if (!this.getFertile() && this.dryTimerMare > -1) {
            --this.dryTimerMare;
        } else {
            this.setFertile(true);
            this.dryTimerMare = AnimaniaConfig.careAndFeeding.gestationTimer / 5 + this.field_70146_Z.nextInt(50);
        }
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        if (this.getColorNumber() > 5) {
            this.setColorNumber(0);
        }
        if (this.fedTimer > -1 && !AnimaniaConfig.gameRules.ambianceMode) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0 && !AnimaniaConfig.gameRules.ambianceMode) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        } else if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 80 + this.field_70146_Z.nextInt(80);
                if (this.getMateUniqueId() != null) {
                    UUID mate = this.getMateUniqueId();
                    boolean mateReset = true;
                    List<EntityStallionBase> entities = AnimaniaHelper.getEntitiesInRange(EntityStallionBase.class, 20.0, this.field_70170_p, (Entity)this);
                    for (int k = 0; k <= entities.size() - 1; ++k) {
                        UUID id;
                        Entity entity = (Entity)entities.get(k);
                        if (entity == null || !(id = entity.getPersistentID()).equals(this.getMateUniqueId()) || entity.field_70128_L) continue;
                        mateReset = false;
                        break;
                    }
                    if (mateReset) {
                        this.setMateUniqueId(null);
                    }
                }
            }
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && AnimaniaConfig.gameRules.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.001;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        if ((gestationTimer = this.getGestation()) > -1 && this.getPregnant()) {
            this.setGestation(--gestationTimer);
            if (gestationTimer == 0) {
                List list = this.field_70170_p.field_72996_f;
                int horseCount = 0;
                int num = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof EntityAnimaniaHorse)) continue;
                    ++num;
                }
                horseCount = num;
                UUID MateID = this.getMateUniqueId();
                List<EntityStallionBase> entities = AnimaniaHelper.getEntitiesInRange(EntityStallionBase.class, 30.0, this.field_70170_p, (Entity)this);
                int esize = entities.size();
                Boolean mateFound = false;
                for (int k = 0; k <= esize - 1; ++k) {
                    EntityStallionBase entity = entities.get(k);
                    if (entity == null || !this.getFed() || !this.getWatered() || !entity.getPersistentID().equals(MateID)) continue;
                    this.func_146082_f(null);
                    HorseType maleType = entity.horseType;
                    HorseType babyType = HorseType.breed(maleType, this.horseType);
                    EntityFoalBase entityFoal = babyType.getChild(this.field_70170_p);
                    entityFoal.func_70107_b(this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entityFoal);
                    }
                    entityFoal.setParentUniqueId(this.getPersistentID());
                    this.func_184185_a(ModSoundEvents.horseliving2, 0.5f, 1.1f);
                    this.setPregnant(false);
                    this.setFertile(false);
                    this.setHasKids(true);
                    BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this, (EntityLiving)entity, (EntityAgeable)entityFoal);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    k = esize;
                    mateFound = true;
                    break;
                }
                if (!mateFound.booleanValue() && this.getFed() && this.getWatered()) {
                    this.func_146082_f(null);
                    HorseType babyType = HorseType.breed(this.horseType, this.horseType);
                    EntityFoalBase entityKid = babyType.getChild(this.field_70170_p);
                    entityKid.func_70107_b(this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entityKid);
                    }
                    entityKid.setParentUniqueId(this.getPersistentID());
                    this.func_184185_a(ModSoundEvents.horseliving2, 0.5f, 1.1f);
                    this.setPregnant(false);
                    this.setFertile(false);
                    this.setHasKids(true);
                    BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this, (EntityLiving)entityKid, (EntityAgeable)entityKid);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    mateFound = true;
                }
            }
        } else if (gestationTimer < 0) {
            this.setGestation(1);
        }
        super.func_70636_d();
    }

    public EntityMareBase createChild(EntityAgeable p_90011_1_) {
        return null;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (player.func_70093_af()) {
            if (this.getMateUniqueId() != null) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.mated"));
            }
            if (this.getFertile() && !this.getPregnant()) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.fertile1"));
            }
            if (this.getPregnant()) {
                if (this.getGestation() > 1) {
                    int bob = this.getGestation();
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1") + " (" + bob + " " + I18n.func_74838_a((String)"text.waila.pregnant2") + ")");
                } else {
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1"));
                }
            }
        }
        TOPInfoProviderMateable.super.addProbeInfo(mode, probeInfo, player, world, entity, data);
    }
}

