/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.pigs;

import com.animania.common.ModSoundEvents;
import com.animania.common.entities.EntityGender;
import com.animania.common.entities.pigs.EntityAnimaniaPig;
import com.animania.common.entities.pigs.EntitySowBase;
import com.animania.common.entities.pigs.ai.EntityAIMatePigs;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.compat.top.providers.entity.TOPInfoProviderPig;
import com.google.common.base.Optional;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHogBase
extends EntityAnimaniaPig
implements TOPInfoProviderPig {
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityHogBase.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityHogBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70138_W = 1.1f;
        this.gender = EntityGender.MALE;
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIMatePigs(this, 1.0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.265);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer entityplayer = (EntityPlayer)entity;
        ItemStack itemstack = entityplayer.func_184614_ca();
        if (itemstack != ItemStack.field_190927_a && itemstack.func_77973_b() == Items.field_151146_bM) {
            return true;
        }
        itemstack = entityplayer.func_184592_cb();
        return itemstack != ItemStack.field_190927_a && itemstack.func_77973_b() == Items.field_151146_bM;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getMateUniqueId() != null) {
            compound.func_74778_a("MateUUID", this.getMateUniqueId().toString());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("MateUUID", 8)) {
            String s = compound.func_74779_i("MateUUID");
        } else {
            String s1 = compound.func_74779_i("Mate");
            String s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
    }

    @Nullable
    public UUID getMateUniqueId() {
        try {
            UUID id = (UUID)((Optional)this.field_70180_af.func_187225_a(MATE_UNIQUE_ID)).orNull();
            return id;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setMateUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(MATE_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 1;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 10 : (happy == 1 ? 20 : 40))) == 0) {
            return ModSoundEvents.hog1;
        }
        if (chooser == 1) {
            return ModSoundEvents.hog2;
        }
        if (chooser == 2) {
            return ModSoundEvents.hog3;
        }
        if (chooser == 3) {
            return ModSoundEvents.hog4;
        }
        if (chooser == 4) {
            return ModSoundEvents.hog5;
        }
        if (chooser == 5) {
            return ModSoundEvents.pig1;
        }
        if (chooser == 6) {
            return ModSoundEvents.pig2;
        }
        if (chooser == 7) {
            return ModSoundEvents.pig4;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.pigHurt1;
        }
        if (chooser == 1) {
            return ModSoundEvents.pigHurt2;
        }
        return ModSoundEvents.pig3;
    }

    protected SoundEvent func_184615_bR() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.pigHurt1;
        }
        if (chooser == 1) {
            return ModSoundEvents.pigHurt2;
        }
        return ModSoundEvents.pig3;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - 0.2f);
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.1f, 0.8f);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() == Items.field_151146_bM && !this.func_184207_aI() && this.getWatered() && this.getFed()) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        if (distance > 5.0f) {
            for (EntityPlayer entityplayer : this.func_184180_b(EntityPlayer.class)) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_187993_u);
            }
        }
    }

    public void func_70612_e(float strafe, float forward) {
        Entity entity;
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (this.func_184207_aI() && this.func_82171_bF()) {
            this.field_70126_B = this.field_70177_z = entity.field_70177_z;
            this.field_70125_A = entity.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.5f;
                if (this.boosting) {
                    if (this.boostTime++ > this.totalBoostTime) {
                        this.boosting = false;
                    }
                    f += f * 1.15f * MathHelper.func_76126_a((float)((float)this.boostTime / (float)this.totalBoostTime * (float)Math.PI));
                }
                this.func_70659_e(f);
                super.func_70612_e(0.0f, 1.0f);
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 200 + this.field_70146_Z.nextInt(200);
                if (this.getMateUniqueId() != null) {
                    UUID mate = this.getMateUniqueId();
                    boolean mateReset = true;
                    List<EntitySowBase> entities = AnimaniaHelper.getEntitiesInRange(EntitySowBase.class, 20.0, this.field_70170_p, (Entity)this);
                    for (int k = 0; k <= entities.size() - 1; ++k) {
                        UUID id;
                        Entity entity = (Entity)entities.get(k);
                        if (entity == null || !(id = entity.getPersistentID()).equals(this.getMateUniqueId()) || entity.field_70128_L) continue;
                        mateReset = false;
                        EntitySowBase fem = (EntitySowBase)entity;
                        if (!fem.getPregnant()) break;
                        this.setHandFed(false);
                        break;
                    }
                    if (mateReset) {
                        this.setMateUniqueId(null);
                    }
                }
            }
        }
        super.func_70636_d();
    }

    public boolean boost() {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.totalBoostTime = this.func_70681_au().nextInt(841) + 140;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 76 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 80) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 76) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 24.0f;
            return 0.62831855f + 0.14660767f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public EntityHogBase createChild(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != ItemStack.field_190927_a && (EntityAnimaniaPig.TEMPTATION_ITEMS.contains(stack.func_77973_b()) || ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.slop));
    }
}

