/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.rodents;

import com.animania.common.AnimaniaAchievements;
import com.animania.common.ModSoundEvents;
import com.animania.common.capabilities.CapabilityRefs;
import com.animania.common.capabilities.ICapabilityPlayer;
import com.animania.common.entities.AnimalContainer;
import com.animania.common.entities.EntityGender;
import com.animania.common.entities.ISpawnable;
import com.animania.common.entities.rodents.HamsterType;
import com.animania.common.entities.rodents.ai.EntityAIFindWater;
import com.animania.common.entities.rodents.ai.EntityAILookIdleRodent;
import com.animania.common.entities.rodents.ai.EntityAIPanicRodents;
import com.animania.common.entities.rodents.ai.EntityAISwimmingRodents;
import com.animania.common.entities.rodents.ai.EntityAITemptHamster;
import com.animania.common.entities.rodents.ai.EntityAIWatchClosestFromSide;
import com.animania.common.handler.ItemHandler;
import com.animania.common.handler.PatreonHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.compat.top.providers.entity.TOPInfoProviderRodent;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityHamster
extends EntityTameable
implements TOPInfoProviderRodent,
ISpawnable {
    private static final DataParameter<Boolean> IN_BALL = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RIDING = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COLOR_NUM = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FOOD_STACK_COUNT = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> IN_LOVE = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BALL_COLOR = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{ItemHandler.hamsterFood});
    private static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> AGE = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final String[] HAMSTER_TEXTURES = new String[]{"black", "brown", "darkbrown", "darkgray", "gray", "plum", "tarou", "white", "gold"};
    private int fedTimer;
    private int wateredTimer;
    private int happyTimer;
    private int tamedTimer;
    public int blinkTimer;
    private long rideCount;
    private int stackCount;
    private int eatCount;
    private int foodStackCount;
    private int standCount;
    private EntityItem targetFood;
    private boolean looksWithInterest;
    private boolean isStanding;
    private float field_25048_b;
    private float field_25054_c;
    private static List hamsterColorList;
    private EntityPlayer givemeEntity;
    private int breeding;
    private boolean mountFlag;
    private double yOffset;
    private ResourceLocation resourceLocation;
    private ResourceLocation resourceLocationBlink;
    private int damageTimer;

    public EntityHamster(World world) {
        super(world);
        this.func_70606_j(6.0f);
        this.yOffset = 0.1f;
        this.func_70105_a(0.5f, 0.3f);
        this.field_70138_W = 1.0f;
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        this.looksWithInterest = false;
        this.stackCount = 20;
        this.eatCount = 5000;
        this.standCount = 30;
        this.isStanding = false;
        this.breeding = 0;
        this.happyTimer = 60;
        this.tamedTimer = 120;
        this.blinkTimer = 70 + this.field_70146_Z.nextInt(70);
        this.func_110163_bv();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanicRodents((EntityCreature)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimmingRodents((EntityLiving)this));
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFindWater((EntityCreature)this, 1.0));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITemptHamster((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosestFromSide((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdleRodent((EntityAnimal)this));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        this.func_184754_b(player.getPersistentID());
        this.setIsTamed(true);
        this.func_70903_f(true);
        this.func_146082_f(player);
        this.doPatreonCheck(player);
        player.func_71064_a((StatBase)AnimaniaAchievements.Hamsters, 1);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190920_e(stack.func_190916_E() - 1);
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public ResourceLocation getResourceLocationBlink() {
        return this.resourceLocationBlink;
    }

    protected void func_70088_a() {
        Random rand = new Random();
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IN_BALL, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
        this.field_70180_af.func_187214_a(COLOR_NUM, (Object)rand.nextInt(8));
        this.field_70180_af.func_187214_a(FOOD_STACK_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(IN_LOVE, (Object)0);
        this.field_70180_af.func_187214_a(BALL_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(RIDING, (Object)false);
        this.field_70180_af.func_187214_a(AGE, (Object)false);
    }

    public boolean getAnimalAge() {
        try {
            return this.getBoolFromDataManager(AGE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setAnimalAge(boolean age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("IsSitting", this.isHamsterSitting());
        nbttagcompound.func_74757_a("InBall", this.isInBall());
        nbttagcompound.func_74768_a("ColorNumber", this.getColorNumber());
        nbttagcompound.func_74768_a("foodStackCount", this.getFoodStackCount());
        nbttagcompound.func_74768_a("BallColor", this.getBallColor());
        nbttagcompound.func_74757_a("Fed", this.getFed());
        nbttagcompound.func_74757_a("Watered", this.getWatered());
        nbttagcompound.func_74757_a("IsTamed", this.getIsTamed());
        nbttagcompound.func_74757_a("IsRiding", this.getIsRiding());
        nbttagcompound.func_74757_a("Age", this.getAnimalAge());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setHamsterSitting(nbttagcompound.func_74767_n("IsSitting"));
        this.setInBall(nbttagcompound.func_74767_n("InBall"));
        this.setColorNumber(nbttagcompound.func_74762_e("ColorNumber"));
        this.setFoodStackCount(nbttagcompound.func_74762_e("foodStackCount"));
        this.setBallColor(nbttagcompound.func_74762_e("BallColor"));
        this.setFed(nbttagcompound.func_74767_n("Fed"));
        this.setWatered(nbttagcompound.func_74767_n("Watered"));
        this.setIsTamed(nbttagcompound.func_74767_n("IsTamed"));
        this.setIsRiding(nbttagcompound.func_74767_n("IsRiding"));
        this.setAnimalAge(nbttagcompound.func_74767_n("Age"));
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public double func_70033_W() {
        return this.yOffset;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack != ItemStack.field_190927_a && itemstack.func_77973_b() == Items.field_151057_cb) {
            if (!itemstack.func_82837_s()) {
                return false;
            }
            EntityHamster entityliving = this;
            entityliving.func_96094_a(itemstack.func_82833_r());
            entityliving.func_110163_bv();
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190920_e(itemstack.func_190916_E() - 1);
            }
            this.setIsTamed(true);
            this.func_70903_f(true);
            this.func_184754_b(player.getPersistentID());
            return true;
        }
        if (itemstack != ItemStack.field_190927_a && itemstack.func_77973_b() == ItemHandler.hamsterFood) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190916_E() <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
            }
            player.func_71064_a((StatBase)AnimaniaAchievements.Hamsters, 1);
            this.func_146082_f(player);
            this.setFed(true);
            this.setIsTamed(true);
            this.func_70903_f(true);
            this.func_184754_b(player.getPersistentID());
            this.doPatreonCheck(player);
            return true;
        }
        if (itemstack != ItemStack.field_190927_a && AnimaniaHelper.isWaterContainer(itemstack)) {
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        if (itemstack == ItemStack.field_190927_a && this.func_70909_n() && !this.isHamsterSitting() && !player.func_70093_af() && !this.isInBall()) {
            this.setHamsterSitting(true);
            this.func_70904_g(true);
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            return true;
        }
        if (itemstack == ItemStack.field_190927_a && this.func_70909_n() && this.isHamsterSitting() && !player.func_70093_af() && !this.isInBall()) {
            this.setHamsterSitting(false);
            this.func_70904_g(false);
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            return true;
        }
        if (itemstack == ItemStack.field_190927_a && !this.func_184218_aH() && player.func_70093_af() && !this.isInBall()) {
            if (!this.getIsRiding()) {
                ICapabilityPlayer props = CapabilityRefs.getPlayerCaps(player);
                props.setMounted(true);
                props.setPetColor(this.getColorNumber());
                props.setPetName(this.func_95999_t());
                props.setPetType("Hamster");
                this.setIsRiding(true);
            }
            return this.interactRide(player);
        }
        if (itemstack == ItemStack.field_190927_a && this.func_70909_n() && this.func_184218_aH() && player.func_70093_af()) {
            if (this.getIsRiding()) {
                ICapabilityPlayer props = CapabilityRefs.getPlayerCaps(player);
                props.setPetColor(this.getColorNumber());
                props.setMounted(false);
                this.setIsRiding(false);
            }
            return this.interactRide(player);
        }
        if (!this.getIsTamed()) {
            if (itemstack != ItemStack.field_190927_a && itemstack.func_77973_b() == ItemHandler.hamsterFood) {
                this.addFoodStack();
                player.func_71064_a((StatBase)AnimaniaAchievements.Hamsters, 1);
                return this.interactSeedsNotTamed(itemstack, player);
            }
            return super.func_184645_a(player, hand);
        }
        if (!this.getIsTamed() && itemstack.func_77973_b() == Items.field_151058_ca) {
            return super.func_184645_a(player, hand);
        }
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() == ItemHandler.hamsterBallColored && !this.isInBall()) {
            this.setInBall(true);
            int meta = itemstack.func_77960_j();
            this.setBallColor(meta);
            if (this.isHamsterSitting()) {
                this.func_70904_g(false);
                this.setHamsterSitting(false);
            }
            itemstack.func_190918_g(1);
            return true;
        }
        if (itemstack.func_190926_b() && this.isInBall()) {
            int color = this.getBallColor();
            this.setInBall(false);
            if (!player.func_184812_l_()) {
                if (color == 16) {
                    AnimaniaHelper.addItem(player, new ItemStack(ItemHandler.hamsterBallClear));
                } else {
                    AnimaniaHelper.addItem(player, new ItemStack(ItemHandler.hamsterBallColored, 1, color));
                }
            }
            return true;
        }
        if (itemstack != ItemStack.field_190927_a && itemstack.func_77973_b() == ItemHandler.hamsterFood) {
            this.addFoodStack();
            player.func_71064_a((StatBase)AnimaniaAchievements.Hamsters, 1);
            return this.interactSeedsTamed(itemstack, player);
        }
        return super.func_184645_a(player, hand);
    }

    private boolean interactSeedsNotTamed(ItemStack itemstack, EntityPlayer entityplayer) {
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        entityplayer.func_71064_a((StatBase)AnimaniaAchievements.Hamsters, 1);
        this.setHamsterStanding(true);
        this.standCount = 100;
        this.doPatreonCheck(entityplayer);
        if (itemstack.func_190916_E() <= 0 && entityplayer.field_71071_by != null) {
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, ItemStack.field_190927_a);
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.field_70699_by.func_75499_g();
            this.field_70703_bu = false;
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        }
        this.func_70691_i(1.0f);
        return true;
    }

    private boolean interactSeedsTamed(ItemStack itemstack, EntityPlayer entityplayer) {
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        if (itemstack.func_190916_E() <= 0) {
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, ItemStack.field_190927_a);
        }
        this.func_70691_i(1.0f);
        return true;
    }

    private boolean interactRide(EntityPlayer entityplayer) {
        this.isRemoteMountEntity((Entity)entityplayer);
        return true;
    }

    private void isRemoteMountEntity(Entity par1Entity) {
        if (this.getIsRiding()) {
            this.setIsRiding(true);
            this.func_184220_m(par1Entity);
            this.rideCount = 0L;
        } else if (!this.getIsRiding()) {
            this.setIsRiding(false);
            this.func_184210_p();
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    private boolean interactOthersTamed() {
        if (this.isHamsterStanding() || !this.isHamsterSitting()) {
            this.setHamsterSitting(true);
        } else if (this.isHamsterSitting()) {
            this.setHamsterSitting(false);
        }
        this.field_70703_bu = false;
        this.field_70699_by.func_75499_g();
        this.func_70624_b(null);
        return true;
    }

    public void func_70691_i(float f) {
        super.func_70691_i(f);
        this.field_70172_ad = this.field_70771_an / 2;
    }

    public boolean func_70067_L() {
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.func_184187_bx();
            ItemStack itemstack = player.field_71071_by.func_70448_g();
            if (itemstack != null) {
                return false;
            }
        }
        return super.func_70067_L();
    }

    public boolean func_70094_T() {
        if (this.func_184187_bx() != null) {
            return false;
        }
        return super.func_70094_T();
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.3;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public void func_70636_d() {
        double d2;
        double d1;
        EntityLivingBase entity;
        EntityPlayer player;
        if (!this.getAnimalAge()) {
            this.setAnimalAge(true);
        }
        if (this.func_184218_aH()) {
            ++this.rideCount;
        }
        if (this.func_184218_aH() && this.func_184187_bx() instanceof EntityPlayer && this.rideCount > 30L && (player = (EntityPlayer)this.func_184187_bx()).func_70093_af()) {
            player.func_184226_ay();
            this.setIsRiding(false);
            ICapabilityPlayer props = CapabilityRefs.getPlayerCaps(player);
            props.setMounted(false);
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 80 + this.field_70146_Z.nextInt(80);
            }
        }
        this.setResourceLoc();
        super.func_70636_d();
        if (this.getIsRiding() && this.func_184187_bx() != null || this.isHamsterSitting()) {
            if (this.func_184187_bx() != null) {
                this.field_70177_z = this.func_184187_bx().field_70177_z;
            }
            this.field_70699_by.func_75499_g();
            this.field_70699_by.func_75489_a(0.0);
        }
        if (this.func_110143_aJ() < 10.0f) {
            this.eatFood();
            this.eatCount = 5000;
        }
        if (!this.isHamsterStanding() && !this.isHamsterSitting()) {
            if (this.field_70146_Z.nextInt(20) == 0 && this.field_70146_Z.nextInt(20) == 0) {
                this.setHamsterStanding(true);
                this.standCount = 30;
                this.field_70699_by.func_75499_g();
                this.field_70703_bu = false;
            }
        } else if (this.isHamsterStanding() && this.standCount-- <= 0 && this.field_70146_Z.nextInt(10) == 0) {
            this.setHamsterStanding(false);
        }
        if (this.getFoodStackCount() > 0) {
            if (this.eatCount == 0) {
                if (this.field_70146_Z.nextInt(30) == 0 && this.field_70146_Z.nextInt(30) == 0) {
                    this.eatFood();
                    this.eatCount = 5000;
                }
            } else {
                --this.eatCount;
            }
        }
        this.looksWithInterest = false;
        if (!this.func_70781_l() && (entity = this.func_70643_av()) instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
            if (itemstack != ItemStack.field_190927_a && itemstack.func_77973_b() == Items.field_151014_N) {
                this.looksWithInterest = true;
            }
        }
        if (this.isHamsterSitting() | this.isHamsterStanding() && this.func_70661_as() != null) {
            this.func_70661_as().func_75499_g();
        }
        if (this.fedTimer > -1 && !AnimaniaConfig.gameRules.ambianceMode) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer != 0 || !AnimaniaConfig.gameRules.ambianceMode) {
                // empty if block
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
            if (AnimaniaConfig.gameRules.animalsStarve) {
                if (this.damageTimer >= AnimaniaConfig.careAndFeeding.starvationTimer) {
                    this.func_70097_a(DamageSource.field_76366_f, 4.0f);
                    this.damageTimer = 0;
                }
                ++this.damageTimer;
            }
        } else if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && AnimaniaConfig.gameRules.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.001;
                    d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        if (this.tamedTimer > -1) {
            --this.tamedTimer;
            if (this.tamedTimer == 0) {
                this.tamedTimer = 120;
                if (this.getIsTamed() && AnimaniaConfig.gameRules.showUnhappyParticles && !this.func_184218_aH()) {
                    double d = this.field_70146_Z.nextGaussian() * 0.02;
                    d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
    }

    public boolean getFed() {
        try {
            return this.getBoolFromDataManager(FED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getWatered() {
        try {
            return this.getBoolFromDataManager(WATERED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_25054_c = this.field_25048_b;
        this.field_25048_b = this.looksWithInterest ? (this.field_25048_b += (1.0f - this.field_25048_b) * 0.4f) : (this.field_25048_b += (0.0f - this.field_25048_b) * 0.4f);
        if (this.looksWithInterest) {
            // empty if block
        }
        if (this.field_70146_Z.nextInt(10) == 5) {
            ++this.field_70173_aa;
        }
    }

    public float getInterestedAngle(float f) {
        return (this.field_25054_c + (this.field_25048_b - this.field_25054_c) * f) * 0.15f * 3.141593f;
    }

    @Nullable
    public UUID getHamsterOwner() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(EntityTameable.field_184756_bw)).orNull();
    }

    public void setHamsterOwner(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(EntityTameable.field_184756_bw, (Object)Optional.fromNullable((Object)uniqueId));
    }

    public boolean isInBall() {
        try {
            return this.getBoolFromDataManager(IN_BALL);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setInBall(boolean ball) {
        if (ball) {
            this.func_184185_a(SoundEvents.field_187719_p, 0.3f, 1.6f);
            this.field_70180_af.func_187227_b(IN_BALL, (Object)true);
        } else {
            this.func_184185_a(SoundEvents.field_187719_p, 0.3f, 1.3f);
            this.field_70180_af.func_187227_b(IN_BALL, (Object)false);
        }
    }

    public int getBallColor() {
        try {
            return this.getIntFromDataManager(BALL_COLOR);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setBallColor(int color) {
        this.field_70180_af.func_187227_b(BALL_COLOR, (Object)color);
    }

    public boolean isHamsterSitting() {
        try {
            return this.getBoolFromDataManager(SITTING);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setHamsterSitting(boolean flag) {
        if (flag) {
            this.field_70180_af.func_187227_b(SITTING, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(SITTING, (Object)false);
        }
    }

    void showHeartsOrSmokeFX(String s, int i, boolean flag) {
        for (int j = 0; j < i; ++j) {
            double d = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            if (this.field_70146_Z.nextInt(2) > 0) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, ModSoundEvents.hamsterEat1, SoundCategory.PLAYERS, 0.6f, 0.8f);
                continue;
            }
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, ModSoundEvents.hamsterEat2, SoundCategory.PLAYERS, 0.6f, 0.8f);
        }
    }

    public boolean getIsTamed() {
        try {
            return this.getBoolFromDataManager(TAMED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setIsTamed(boolean tamed) {
        if (tamed) {
            this.field_70180_af.func_187227_b(TAMED, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)false);
        }
    }

    public boolean getIsRiding() {
        try {
            return this.getBoolFromDataManager(RIDING);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setIsRiding(boolean riding) {
        if (riding) {
            this.field_70180_af.func_187227_b(RIDING, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(RIDING, (Object)false);
        }
    }

    public boolean isHamsterStanding() {
        return this.isStanding;
    }

    public void setHamsterStanding(boolean flag) {
        this.isStanding = flag;
    }

    protected void func_70628_a(boolean hit, int lootlevel) {
        EntityItem entityitem;
        ItemStack dropItem;
        int happyDrops = 0;
        if (this.getWatered()) {
            ++happyDrops;
        }
        if (this.getFed()) {
            ++happyDrops;
        }
        if (AnimaniaConfig.drops.customMobDrops) {
            String drop = AnimaniaConfig.drops.hamsterDrop;
            dropItem = AnimaniaHelper.getItem(drop);
        } else {
            dropItem = null;
        }
        String drop2 = AnimaniaConfig.drops.hamsterDrop2;
        ItemStack dropItem2 = AnimaniaHelper.getItem(drop2);
        if (happyDrops == 2) {
            if (dropItem != null) {
                dropItem.func_190920_e(1 + lootlevel);
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, dropItem);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (dropItem2 != null) {
                this.func_145779_a(dropItem2.func_77973_b(), AnimaniaConfig.drops.hamsterDrop2Amount + lootlevel);
            }
        } else if (happyDrops == 1) {
            if (dropItem != null) {
                dropItem.func_190920_e(1 + lootlevel);
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, dropItem);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (dropItem2 != null) {
                this.func_145779_a(dropItem2.func_77973_b(), AnimaniaConfig.drops.hamsterDrop2Amount + lootlevel);
            }
        }
        if (this.isInBall()) {
            int color = this.getBallColor();
            if (color == 16) {
                this.func_70099_a(new ItemStack(ItemHandler.hamsterBallClear), 0.0f);
            } else {
                this.func_70099_a(new ItemStack(ItemHandler.hamsterBallColored, 1, color), 0.0f);
            }
        }
    }

    private ItemStack getItem(String moditem) {
        Item bob;
        ItemStack foundStack = null;
        String item = "";
        String mod = "";
        int sepLoc = 0;
        int metaLoc = 0;
        boolean metaFlag = false;
        String metaVal = "";
        sepLoc = moditem.indexOf(":");
        metaLoc = moditem.indexOf("#");
        if (!moditem.contains(":")) {
            return new ItemStack(Blocks.field_150350_a, 1);
        }
        mod = moditem.substring(0, sepLoc);
        item = metaLoc > 0 ? moditem.substring(sepLoc + 1, metaLoc) : moditem.substring(sepLoc + 1, moditem.length());
        if (metaLoc > 0) {
            metaFlag = true;
            metaVal = moditem.substring(metaLoc + 1, moditem.length());
        }
        foundStack = (bob = Item.func_111206_d((String)item)) != null ? (metaFlag ? new ItemStack(bob, 1, Integer.parseInt(metaVal)) : new ItemStack(bob, 1)) : new ItemStack(Blocks.field_150350_a, 1);
        return foundStack;
    }

    public int getFoodStackCount() {
        return this.foodStackCount;
    }

    public void setFoodStackCount(int i) {
        this.foodStackCount = i;
    }

    public int getColorNumber() {
        try {
            return this.getIntFromDataManager(COLOR_NUM);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setColorNumber(int color) {
        this.field_70180_af.func_187227_b(COLOR_NUM, (Object)color);
    }

    private boolean addFoodStack() {
        if (this.foodStackCount != 5) {
            ++this.foodStackCount;
            return true;
        }
        this.func_70691_i(1.0f);
        return false;
    }

    private boolean eatFood() {
        if (this.foodStackCount != 0) {
            --this.foodStackCount;
            this.func_70691_i(1.0f);
            return true;
        }
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityanimal) {
        return null;
    }

    public double func_70042_X() {
        return this.field_70131_O;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != ItemStack.field_190927_a && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 1;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 6 : (happy == 1 ? 12 : 24))) == 0) {
            return ModSoundEvents.hamsterLiving1;
        }
        if (chooser == 1) {
            return ModSoundEvents.hamsterLiving2;
        }
        if (chooser == 2) {
            return ModSoundEvents.hamsterLiving3;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        return ModSoundEvents.hamsterHurt1;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP() - 0.2f, this.func_70647_i());
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.02f, 1.8f);
    }

    private void doPatreonCheck(EntityPlayer player) {
        if (player.func_70093_af() && PatreonHandler.isPlayerPatreon(player)) {
            this.setColorNumber(8);
            this.resourceLocation = null;
        }
    }

    public void setResourceLoc() {
        if (this.getColorNumber() == 9) {
            this.setColorNumber(8);
        } else if (this.getColorNumber() > 9) {
            this.setColorNumber(0);
        }
        if (this.resourceLocation == null) {
            this.resourceLocation = new ResourceLocation("animania:textures/entity/rodents/hamster_" + HAMSTER_TEXTURES[this.getColorNumber()] + ".png");
            this.resourceLocationBlink = new ResourceLocation("animania:textures/entity/rodents/hamster_" + HAMSTER_TEXTURES[this.getColorNumber()] + "_blink.png");
        }
    }

    @Override
    public Item getSpawnEgg() {
        return ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(HamsterType.STANDARD, EntityGender.NONE));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 14603464;
    }

    @Override
    public int getSecondaryEggColor() {
        return 14317391;
    }

    @Override
    public EntityGender getEntityGender() {
        return EntityGender.NONE;
    }

    public boolean getBoolFromDataManager(DataParameter<Boolean> key) {
        try {
            return (Boolean)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIntFromDataManager(DataParameter<Integer> key) {
        try {
            return (Integer)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFromDataManager(DataParameter<Float> key) {
        try {
            return ((Float)this.func_184212_Q().func_187225_a(key)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<UUID> getUUIDFromDataManager(DataParameter<Optional<UUID>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack getItemStackFromDataManager(DataParameter<ItemStack> key) {
        try {
            return (ItemStack)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return ItemStack.field_190927_a;
        }
    }

    public Optional<BlockPos> getBlockPosFromDataManager(DataParameter<Optional<BlockPos>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }
}

