/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.rodents.ai;

import com.animania.common.entities.ISpawnable;
import com.animania.common.entities.rodents.EntityFerretBase;
import com.animania.common.entities.rodents.EntityHamster;
import com.animania.common.entities.rodents.EntityHedgehogBase;
import com.animania.common.entities.rodents.rabbits.EntityAnimaniaRabbit;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class EntityAIFindWater
extends EntityAIBase {
    private final EntityCreature temptedEntity;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    private EntityPlayer temptingPlayer;
    private int delayTemptCounter;
    private boolean isRunning;

    public EntityAIFindWater(EntityCreature temptedEntityIn, double speedIn) {
        this.temptedEntity = temptedEntityIn;
        this.speed = speedIn;
        this.func_75248_a(3);
        this.delayTemptCounter = 0;
    }

    public boolean func_75250_a() {
        ++this.delayTemptCounter;
        if (this.delayTemptCounter < 60) {
            return false;
        }
        if (this.delayTemptCounter > 60) {
            ISpawnable entity;
            if (this.temptedEntity instanceof EntityFerretBase) {
                entity = (EntityFerretBase)this.temptedEntity;
                if (((EntityFerretBase)entity).getWatered()) {
                    this.delayTemptCounter = 0;
                    return false;
                }
            } else if (this.temptedEntity instanceof EntityHamster) {
                entity = (EntityHamster)this.temptedEntity;
                if (((EntityHamster)entity).getWatered()) {
                    this.delayTemptCounter = 0;
                    return false;
                }
            } else if (this.temptedEntity instanceof EntityHedgehogBase) {
                entity = (EntityHedgehogBase)this.temptedEntity;
                if (((EntityHedgehogBase)entity).getWatered()) {
                    this.delayTemptCounter = 0;
                    return false;
                }
            } else if (this.temptedEntity instanceof EntityAnimaniaRabbit && ((EntityAnimaniaRabbit)(entity = (EntityAnimaniaRabbit)this.temptedEntity)).getWatered()) {
                this.delayTemptCounter = 0;
                return false;
            }
            if (this.temptedEntity.func_70681_au().nextInt(100) == 0) {
                Vec3d vec3d = RandomPositionGenerator.func_75463_a((EntityCreature)this.temptedEntity, (int)20, (int)4);
                if (vec3d != null) {
                    this.delayTemptCounter = 0;
                    this.func_75251_c();
                    this.temptedEntity.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.speed);
                }
                return false;
            }
            Random rand = new Random();
            BlockPos currentpos = new BlockPos(this.temptedEntity.field_70165_t, this.temptedEntity.field_70163_u, this.temptedEntity.field_70161_v);
            BlockPos currentposlower = new BlockPos(this.temptedEntity.field_70165_t, this.temptedEntity.field_70163_u - 1.0, this.temptedEntity.field_70161_v);
            Block poschk = this.temptedEntity.field_70170_p.func_180495_p(currentpos).func_177230_c();
            Block poschk1 = this.temptedEntity.field_70170_p.func_180495_p(currentposlower).func_177230_c();
            Biome biomegenbase = this.temptedEntity.field_70170_p.func_180494_b(new BlockPos(this.temptedEntity.field_70165_t, this.temptedEntity.field_70163_u, this.temptedEntity.field_70161_v));
            if (!(poschk != Blocks.field_150355_j && poschk1 != Blocks.field_150355_j || BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH))) {
                if (this.temptedEntity instanceof EntityFerretBase) {
                    EntityFerretBase entity2 = (EntityFerretBase)this.temptedEntity;
                    entity2.setWatered(true);
                } else if (this.temptedEntity instanceof EntityHamster) {
                    EntityHamster entity3 = (EntityHamster)this.temptedEntity;
                    entity3.setWatered(true);
                } else if (this.temptedEntity instanceof EntityHedgehogBase) {
                    EntityHedgehogBase entity4 = (EntityHedgehogBase)this.temptedEntity;
                    entity4.setWatered(true);
                } else if (this.temptedEntity instanceof EntityAnimaniaRabbit) {
                    EntityAnimaniaRabbit entity5 = (EntityAnimaniaRabbit)this.temptedEntity;
                    entity5.setWatered(true);
                }
                this.delayTemptCounter = 0;
                return false;
            }
            double x = this.temptedEntity.field_70165_t;
            double y = this.temptedEntity.field_70163_u;
            double z = this.temptedEntity.field_70161_v;
            boolean waterFound = false;
            BlockPos pos = new BlockPos(x, y, z);
            for (int i = -10; i < 10; ++i) {
                for (int j = -3; j < 3; ++j) {
                    for (int k = -10; k < 10; ++k) {
                        pos = new BlockPos(x + (double)i, y + (double)j, z + (double)k);
                        Block blockchk = this.temptedEntity.field_70170_p.func_180495_p(pos).func_177230_c();
                        if (blockchk != Blocks.field_150355_j) continue;
                        waterFound = true;
                        if (rand.nextInt(200) == 0) {
                            this.delayTemptCounter = 0;
                            return false;
                        }
                        if (this.temptedEntity.field_70123_F && this.temptedEntity.field_70159_w == 0.0 && this.temptedEntity.field_70179_y == 0.0) {
                            this.delayTemptCounter = 0;
                            return false;
                        }
                        return true;
                    }
                }
            }
            if (!waterFound) {
                this.delayTemptCounter = 0;
                return false;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.temptedEntity.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.temptingPlayer = null;
        this.temptedEntity.func_70661_as().func_75499_g();
        this.isRunning = false;
    }

    public void func_75249_e() {
        double x = this.temptedEntity.field_70165_t;
        double y = this.temptedEntity.field_70163_u;
        double z = this.temptedEntity.field_70161_v;
        BlockPos currentpos = new BlockPos(x, y, z);
        Block poschk = this.temptedEntity.field_70170_p.func_180495_p(currentpos).func_177230_c();
        if (poschk != Blocks.field_150355_j) {
            boolean waterFound = false;
            int loc = 24;
            int newloc = 24;
            BlockPos pos = new BlockPos(x, y, z);
            BlockPos waterPos = new BlockPos(x, y, z);
            for (int i = -10; i < 10; ++i) {
                for (int j = -3; j < 3; ++j) {
                    for (int k = -10; k < 10; ++k) {
                        BlockPos waterPoschk;
                        Block waterBlockchk;
                        pos = new BlockPos(x + (double)i, y + (double)j, z + (double)k);
                        Block blockchk = this.temptedEntity.field_70170_p.func_180495_p(pos).func_177230_c();
                        Biome biomegenbase = this.temptedEntity.field_70170_p.func_180494_b(waterPos);
                        if (blockchk != Blocks.field_150355_j || BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) continue;
                        waterFound = true;
                        newloc = Math.abs(i) + Math.abs(j) + Math.abs(k);
                        if (newloc >= loc) continue;
                        loc = newloc;
                        if (this.temptedEntity.field_70165_t < (double)waterPos.func_177958_n() && (waterBlockchk = this.temptedEntity.field_70170_p.func_180495_p(waterPoschk = new BlockPos(x + (double)i + 1.0, y + (double)j, z + (double)k)).func_177230_c()) == Blocks.field_150355_j) {
                            ++i;
                        }
                        if (this.temptedEntity.field_70161_v < (double)waterPos.func_177952_p() && (waterBlockchk = this.temptedEntity.field_70170_p.func_180495_p(waterPoschk = new BlockPos(x + (double)i, y + (double)j, z + (double)k + 1.0)).func_177230_c()) == Blocks.field_150355_j) {
                            ++k;
                        }
                        waterPos = new BlockPos(x + (double)i, y + (double)j, z + (double)k);
                    }
                }
            }
            if (waterFound) {
                Block waterBlockchk = this.temptedEntity.field_70170_p.func_180495_p(waterPos).func_177230_c();
                Biome biomegenbase = this.temptedEntity.field_70170_p.func_180494_b(waterPos);
                if (waterBlockchk == Blocks.field_150355_j && !BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && !BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                    if (!this.temptedEntity.func_70661_as().func_75492_a((double)waterPos.func_177958_n(), (double)waterPos.func_177956_o(), (double)waterPos.func_177952_p(), this.speed)) {
                        this.delayTemptCounter = 0;
                    } else {
                        this.temptedEntity.func_70661_as().func_75492_a((double)waterPos.func_177958_n(), (double)waterPos.func_177956_o(), (double)waterPos.func_177952_p(), this.speed);
                    }
                }
            }
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

