/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.sheep;

import com.animania.common.entities.AnimaniaType;
import com.animania.common.entities.sheep.EntityEweBase;
import com.animania.common.entities.sheep.EntityEweDorper;
import com.animania.common.entities.sheep.EntityEweDorset;
import com.animania.common.entities.sheep.EntityEweFriesian;
import com.animania.common.entities.sheep.EntityEweJacob;
import com.animania.common.entities.sheep.EntityEweMerino;
import com.animania.common.entities.sheep.EntityEweSuffolk;
import com.animania.common.entities.sheep.EntityLambBase;
import com.animania.common.entities.sheep.EntityLambDorper;
import com.animania.common.entities.sheep.EntityLambDorset;
import com.animania.common.entities.sheep.EntityLambFriesian;
import com.animania.common.entities.sheep.EntityLambJacob;
import com.animania.common.entities.sheep.EntityLambMerino;
import com.animania.common.entities.sheep.EntityLambSuffolk;
import com.animania.common.entities.sheep.EntityRamBase;
import com.animania.common.entities.sheep.EntityRamDorper;
import com.animania.common.entities.sheep.EntityRamDorset;
import com.animania.common.entities.sheep.EntityRamFriesian;
import com.animania.common.entities.sheep.EntityRamJacob;
import com.animania.common.entities.sheep.EntityRamMerino;
import com.animania.common.entities.sheep.EntityRamSuffolk;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public enum SheepType implements AnimaniaType
{
    DORPER(EntityRamDorper.class, EntityEweDorper.class, EntityLambDorper.class),
    DORSET(EntityRamDorset.class, EntityEweDorset.class, EntityLambDorset.class),
    FRIESIAN(EntityRamFriesian.class, EntityEweFriesian.class, EntityLambFriesian.class),
    JACOB(EntityRamJacob.class, EntityEweJacob.class, EntityLambJacob.class),
    MERINO(EntityRamMerino.class, EntityEweMerino.class, EntityLambMerino.class),
    SUFFOLK(EntityRamSuffolk.class, EntityEweSuffolk.class, EntityLambSuffolk.class);

    private Class male;
    private Class female;
    private Class child;
    private StatBase achievement;

    private SheepType(Class male, Class female, Class child) {
        this.male = male;
        this.female = female;
        this.child = child;
    }

    public void setAchievement(StatBase achievement) {
        this.achievement = achievement;
    }

    public EntityRamBase getMale(World world) {
        Constructor constructor = null;
        try {
            constructor = this.male.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityRamBase male = null;
        try {
            male = (EntityRamBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return male;
    }

    public EntityEweBase getFemale(World world) {
        Constructor constructor = null;
        try {
            constructor = this.female.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityEweBase female = null;
        try {
            female = (EntityEweBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return female;
    }

    public EntityLambBase getChild(World world) {
        Constructor constructor = null;
        try {
            constructor = this.child.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityLambBase child = null;
        try {
            child = (EntityLambBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return child;
    }

    public static SheepType breed(SheepType male, SheepType female) {
        Random rand = new Random();
        if (rand.nextInt(2) == 0) {
            return male;
        }
        return female;
    }

    public StatBase getAchievement() {
        return this.achievement;
    }
}

