/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.handler;

import com.animania.common.blocks.BlockSeeds;
import com.animania.common.entities.EntityGender;
import com.animania.common.entities.RandomAnimalType;
import com.animania.common.entities.chickens.ChickenType;
import com.animania.common.entities.cows.CowType;
import com.animania.common.entities.goats.GoatType;
import com.animania.common.entities.peacocks.PeacockType;
import com.animania.common.entities.pigs.PigType;
import com.animania.common.entities.rodents.rabbits.RabbitType;
import com.animania.common.handler.BlockHandler;
import com.animania.common.items.ItemEntityEgg;
import com.animania.config.AnimaniaConfig;
import java.util.Random;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.Loader;

public class DispenserHandler {
    public static final IBehaviorDispenseItem SEEDS_DISPENSER_BEHAVIOUR = new BehaviorDefaultDispenseItem(){
        private final BehaviorDefaultDispenseItem behaviourDefaultDispenseItem = new BehaviorDefaultDispenseItem();

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            EnumFacing enumfacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            World world = source.func_82618_k();
            BlockPos pos = source.func_180699_d().func_177972_a(enumfacing);
            BlockPos below = pos.func_177972_a(EnumFacing.DOWN);
            Item item = stack.func_77973_b();
            if (world.func_180495_p(pos).func_177230_c() != BlockHandler.blockSeeds && world.func_180495_p(below).func_185913_b() && world.func_180495_p(below).func_185914_p() && !(world.func_180495_p(below).func_177230_c() instanceof BlockFarmland) && !(world.func_180495_p(below).func_177230_c() instanceof IPlantable) && AnimaniaConfig.gameRules.allowSeedDispenserPlacement) {
                if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                    if (item == Items.field_151014_N) {
                        world.func_175656_a(pos, BlockHandler.blockSeeds.func_176223_P());
                    } else if (item == Items.field_151080_bb) {
                        world.func_175656_a(pos, BlockHandler.blockSeeds.func_176223_P().func_177226_a(BlockSeeds.VARIANT, (Comparable)((Object)BlockSeeds.EnumType.PUMPKIN)));
                    } else if (item == Items.field_151081_bc) {
                        world.func_175656_a(pos, BlockHandler.blockSeeds.func_176223_P().func_177226_a(BlockSeeds.VARIANT, (Comparable)((Object)BlockSeeds.EnumType.MELON)));
                    } else if (item == Items.field_185163_cU) {
                        world.func_175656_a(pos, BlockHandler.blockSeeds.func_176223_P().func_177226_a(BlockSeeds.VARIANT, (Comparable)((Object)BlockSeeds.EnumType.BEETROOT)));
                    }
                    stack.func_190918_g(1);
                    return stack;
                }
            } else if ((Loader.isModLoaded((String)"quark") || Loader.isModLoaded((String)"botania")) && world.func_180495_p(below).func_177230_c() instanceof BlockFarmland) {
                if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                    if (item == Items.field_151014_N) {
                        world.func_175656_a(pos, Blocks.field_150464_aj.func_176223_P());
                    } else if (item == Items.field_151080_bb) {
                        world.func_175656_a(pos, Blocks.field_150393_bb.func_176223_P());
                    } else if (item == Items.field_151081_bc) {
                        world.func_175656_a(pos, Blocks.field_150394_bc.func_176223_P());
                    } else if (item == Items.field_185163_cU) {
                        world.func_175656_a(pos, Blocks.field_185773_cZ.func_176223_P());
                    }
                    return stack;
                }
            } else if (world.func_180495_p(pos).func_177230_c() == BlockHandler.blockSeeds) {
                return stack;
            }
            return super.func_82487_b(source, stack);
        }
    };
    public static final IBehaviorDispenseItem SPAWNEGG_DISPENSER_BEHAVIOUR = new BehaviorDefaultDispenseItem(){
        private final BehaviorDefaultDispenseItem behaviourDefaultDispenseItem = new BehaviorDefaultDispenseItem();

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            EnumFacing enumfacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            World world = source.func_82618_k();
            BlockPos pos = source.func_180699_d().func_177972_a(enumfacing);
            ItemEntityEgg item = (ItemEntityEgg)stack.func_77973_b();
            EntityLivingBase entity = null;
            if (item.gender == EntityGender.RANDOM) {
                Random rand = new Random();
                if (item.type instanceof CowType) {
                    CowType cfr_ignored_0 = (CowType)item.type;
                    entity = EntityGender.getEntity(CowType.values()[rand.nextInt(CowType.values().length)], item.gender, world);
                }
                if (item.type instanceof PigType) {
                    PigType cfr_ignored_1 = (PigType)item.type;
                    entity = EntityGender.getEntity(PigType.values()[rand.nextInt(PigType.values().length)], item.gender, world);
                }
                if (item.type instanceof ChickenType) {
                    ChickenType cfr_ignored_2 = (ChickenType)item.type;
                    entity = EntityGender.getEntity(ChickenType.values()[rand.nextInt(ChickenType.values().length)], item.gender, world);
                }
                if (item.type instanceof GoatType) {
                    GoatType cfr_ignored_3 = (GoatType)item.type;
                    entity = EntityGender.getEntity(GoatType.values()[rand.nextInt(GoatType.values().length)], item.gender, world);
                }
                if (item.type instanceof PeacockType) {
                    PeacockType cfr_ignored_4 = (PeacockType)item.type;
                    entity = EntityGender.getEntity(PeacockType.values()[rand.nextInt(PeacockType.values().length)], item.gender, world);
                }
                if (item.type instanceof RabbitType) {
                    RabbitType cfr_ignored_5 = (RabbitType)item.type;
                    entity = EntityGender.getEntity(RabbitType.values()[rand.nextInt(RabbitType.values().length)], item.gender, world);
                }
                if (item.type instanceof RandomAnimalType) {
                    entity = EntityGender.getEntity(item.type, item.gender, world);
                }
            } else {
                entity = EntityGender.getEntity(item.type, item.gender, world);
            }
            if (entity != null) {
                entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                if (stack.func_82837_s()) {
                    entity.func_96094_a(stack.func_82833_r());
                }
                stack.func_190918_g(1);
                world.func_72838_d((Entity)entity);
            }
            return stack;
        }
    };

    public static void init() {
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151014_N, (Object)SEEDS_DISPENSER_BEHAVIOUR);
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151080_bb, (Object)SEEDS_DISPENSER_BEHAVIOUR);
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151081_bc, (Object)SEEDS_DISPENSER_BEHAVIOUR);
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_185163_cU, (Object)SEEDS_DISPENSER_BEHAVIOUR);
        for (ResourceLocation path : Item.field_150901_e.func_148742_b()) {
            Item item = Item.func_111206_d((String)path.toString());
            if (!(item instanceof ItemEntityEgg)) continue;
            BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)SPAWNEGG_DISPENSER_BEHAVIOUR);
        }
    }
}

