/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.helper;

import com.animania.Animania;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class RegistryHelper {

    public static class Entities {
        public static void register(Class<? extends Entity> entityClass, String entityName, int entityID, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            ResourceLocation registryName = new ResourceLocation("animania", entityName);
            EntityRegistry.registerModEntity((ResourceLocation)registryName, entityClass, (String)registryName.toString(), (int)entityID, (Object)Animania.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        }

        public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int entityID, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
            ResourceLocation registryName = new ResourceLocation("animania", entityName);
            EntityRegistry.registerModEntity((ResourceLocation)registryName, entityClass, (String)registryName.toString(), (int)entityID, (Object)Animania.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)eggPrimary, (int)eggSecondary);
        }

        public static void addSpawn(Class<? extends EntityLiving> entityClass, int weightedProb, int min, int max, EnumCreatureType typeOfCreature, Biome ... biomes) {
            EntityRegistry.addSpawn(entityClass, (int)weightedProb, (int)min, (int)max, (EnumCreatureType)typeOfCreature, (Biome[])biomes);
        }

        public static void copySpawns(Class<? extends EntityLiving> classToAdd, EnumCreatureType creatureTypeToAdd, Class<? extends EntityLiving> classToCopy, EnumCreatureType creatureTypeToCopy) {
            for (Biome biome : ForgeRegistries.BIOMES) {
                biome.func_76747_a(creatureTypeToCopy).stream().filter(entry -> entry.field_76300_b == classToCopy).findFirst().ifPresent(spawnListEntry -> biome.func_76747_a(creatureTypeToAdd).add(new Biome.SpawnListEntry(classToAdd, spawnListEntry.field_76292_a, spawnListEntry.field_76301_c, spawnListEntry.field_76299_d)));
            }
        }

        public static Biome[] getBiomes(BiomeDictionary.Type type) {
            return (Biome[])BiomeDictionary.getBiomes((BiomeDictionary.Type)type).stream().toArray(Biome[]::new);
        }
    }

    public static class Item {
        public static void register(net.minecraft.item.Item item) {
            ModelLoader.setCustomModelResourceLocation((net.minecraft.item.Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("animania:" + item.func_77658_a(), "inventory"));
        }
    }
}

