/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.items;

import com.animania.Animania;
import com.animania.common.handler.FoodValueHandler;
import com.animania.common.helper.RomanNumberHelper;
import com.animania.common.helper.TimeHelper;
import com.animania.config.AnimaniaConfig;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ItemAnimaniaFood
extends ItemFood {
    private PotionEffect[] effects;
    private String name;

    public ItemAnimaniaFood(int amount, float saturation, boolean isWolfFood, String name, boolean creativeTab, PotionEffect ... potionEffects) {
        super(amount, saturation, isWolfFood);
        this.setRegistryName(new ResourceLocation("animania", name));
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_77655_b("animania_" + name);
        this.effects = potionEffects;
        this.name = name;
        this.func_77848_i();
        this.func_77637_a(Animania.TabAnimaniaResources);
    }

    public int func_150905_g(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (FoodValueHandler.hasOverride(item)) {
            return FoodValueHandler.getHealAmount(item);
        }
        return super.func_150905_g(stack);
    }

    public float func_150906_h(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (FoodValueHandler.hasOverride(item)) {
            return FoodValueHandler.getSaturation(item);
        }
        return super.func_150906_h(stack);
    }

    public ItemAnimaniaFood(int amount, float saturation, boolean isWolfFood, String name) {
        this(amount, saturation, isWolfFood, name, true, new PotionEffect[0]);
    }

    public ItemAnimaniaFood(int amount, float saturation, String name) {
        this(amount, saturation, true, name, true, new PotionEffect[0]);
    }

    public ItemAnimaniaFood(int amount, float saturation, String name, boolean creativeTab, PotionEffect ... potionEffects) {
        this(amount, saturation, true, name, creativeTab, potionEffects);
    }

    public ItemAnimaniaFood(int amount, float saturation, String name, PotionEffect ... potionEffects) {
        this(amount, saturation, true, name, true, potionEffects);
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.EAT;
    }

    public String getName() {
        return this.name;
    }

    protected void func_77849_c(ItemStack itemstack, World worldObj, EntityPlayer entityplayer) {
        if (!worldObj.field_72995_K && AnimaniaConfig.gameRules.foodsGiveBonusEffects && this.effects != null) {
            for (PotionEffect effect : (PotionEffect[])this.effects.clone()) {
                Potion pot = effect.func_188419_a();
                int duration = effect.func_76459_b();
                int amplifier = effect.func_76458_c();
                boolean isAmbient = effect.func_82720_e();
                entityplayer.func_70690_d(new PotionEffect(pot, duration, amplifier, isAmbient, false));
            }
        }
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean advanced) {
        if (AnimaniaConfig.gameRules.foodsGiveBonusEffects && this.effects != null) {
            for (PotionEffect effect : (PotionEffect[])this.effects.clone()) {
                Potion pot = effect.func_188419_a();
                int duration = effect.func_76459_b();
                int amplifier = effect.func_76458_c();
                boolean isInstant = pot.func_76403_b();
                boolean isPositive = pot.func_188408_i();
                String name = pot.getRegistryName().func_110623_a().replace("_", "");
                if (!isPositive) continue;
                list.add(TextFormatting.GREEN + I18n.func_74838_a((String)("tooltip.an." + name)) + " " + RomanNumberHelper.toRoman(amplifier + 1) + (!isInstant ? " (" + TimeHelper.getTime(duration) + ")" : ""));
            }
        }
        list.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.an.edibleanytime"));
    }
}

