/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.tileentities;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.animania.common.ModSoundEvents;
import com.animania.common.entities.rodents.EntityHamster;
import com.animania.common.handler.BlockHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.tileentities.handler.ItemHandlerHamsterWheel;
import com.animania.config.AnimaniaConfig;
import com.leviathanstudio.craftstudio.CraftStudioApi;
import com.leviathanstudio.craftstudio.common.animation.AnimationHandler;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import com.leviathanstudio.craftstudio.common.animation.simpleImpl.AnimatedTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityHamsterWheel
extends AnimatedTileEntity
implements ITickable,
IEnergyProvider {
    private static AnimationHandler animHandler = CraftStudioApi.getNewAnimationHandler(TileEntityHamsterWheel.class);
    private boolean isRunning;
    private EntityHamster hamster;
    private NBTTagCompound hamsterNBT;
    private ItemHandlerHamsterWheel itemHandler = new ItemHandlerHamsterWheel();
    private int timer;
    private int energy;
    private int nbtSyncTimer;

    public void func_73660_a() {
        super.func_73660_a();
        if (this.hamster == null && this.hamsterNBT != null) {
            this.hamster = new EntityHamster(this.field_145850_b);
            this.hamster.func_70020_e(this.hamsterNBT);
        }
        if (this.hamster != null) {
            this.isRunning = true;
            this.func_70296_d();
        } else {
            this.isRunning = false;
        }
        if (this.isRunning) {
            this.energy += AnimaniaConfig.gameRules.hamsterWheelRFGeneration;
            if (this.energy > AnimaniaConfig.gameRules.hamsterWheelCapacity) {
                this.energy = AnimaniaConfig.gameRules.hamsterWheelCapacity;
            }
            ++this.timer;
            this.func_70296_d();
        }
        if (this.timer >= AnimaniaConfig.gameRules.hamsterWheelUseTime) {
            if (!this.itemHandler.getStackInSlot(0).func_190926_b()) {
                ItemStack stack = this.itemHandler.getStackInSlot(0).func_77946_l();
                stack.func_190918_g(1);
                this.itemHandler.setStackInSlot(0, stack);
            } else {
                this.ejectHamster();
                this.isRunning = false;
            }
            this.timer = 0;
            this.func_70296_d();
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (this.getSurroundingTE(facing) != null && (this.getSurroundingTE(facing) instanceof IEnergyReceiver || this.getSurroundingTE(facing).hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()))) {
                int recieved;
                if (this.getSurroundingTE(facing) instanceof IEnergyReceiver) {
                    IEnergyReceiver reciever = (IEnergyReceiver)this.getSurroundingTE(facing);
                    recieved = reciever.receiveEnergy(facing.func_176734_d(), this.energy, false);
                    this.energy -= recieved;
                } else {
                    IEnergyStorage energyStorage = (IEnergyStorage)this.getSurroundingTE(facing).getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d());
                    if (energyStorage.canReceive()) {
                        recieved = energyStorage.receiveEnergy(this.energy, false);
                        this.energy -= recieved;
                    }
                }
            }
            this.func_70296_d();
        }
        this.updateAnims();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public EntityHamster getHamster() {
        return this.hamster;
    }

    public void setHamster(EntityHamster hamster) {
        this.hamster = hamster;
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void ejectHamster() {
        if (this.hamster != null && !this.field_145850_b.field_72995_K) {
            if (this.findPositionForHamster()) {
                this.field_145850_b.func_72838_d((Entity)this.hamster);
                Random rand = new Random();
                this.hamster.func_184185_a(SoundEvents.field_187638_cR, 1.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
                this.hamster.setFed(false);
                this.hamster = null;
                this.hamsterNBT = null;
            } else {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ModSoundEvents.hamsterDeath, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                this.hamster = null;
                this.hamsterNBT = null;
            }
        }
    }

    private boolean findPositionForHamster() {
        for (EnumFacing e : EnumFacing.field_82609_l) {
            BlockPos pos = this.field_174879_c;
            IBlockState state = this.field_145850_b.func_180495_p(pos = pos.func_177972_a(e));
            if (state.func_185896_q() || state.func_185917_h() || state.func_177230_c() == BlockHandler.blockHamsterWheel) continue;
            this.hamster.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            return true;
        }
        return false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tag = super.func_189515_b(compound);
        tag.func_74768_a("energy", this.energy);
        tag.func_74757_a("running", this.isRunning);
        tag.func_74768_a("timer", this.timer);
        NBTTagCompound hamster = new NBTTagCompound();
        NBTTagCompound items = this.itemHandler.serializeNBT();
        tag.func_74782_a("hamster", (NBTBase)(this.hamster == null ? hamster : this.hamster.func_189511_e(hamster)));
        tag.func_74782_a("items", (NBTBase)items);
        return tag;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.energy = compound.func_74762_e("energy");
        NBTTagCompound hamster = compound.func_74775_l("hamster");
        if (!hamster.equals((Object)new NBTTagCompound())) {
            this.hamsterNBT = hamster;
        } else {
            this.hamsterNBT = null;
            this.hamster = null;
        }
        this.isRunning = compound.func_74767_n("running");
        this.timer = compound.func_74762_e("timer");
        this.itemHandler.deserializeNBT(compound.func_74775_l("items"));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        if (this.field_145854_h != null && this.field_174879_c != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145854_h.func_176223_P(), this.field_145854_h.func_176223_P(), 1);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_189515_b(tagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return AnimaniaConfig.gameRules.hamsterWheelCapacity;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        this.energy -= maxExtract;
        return maxExtract;
    }

    private TileEntity getSurroundingTE(EnumFacing facing) {
        BlockPos pos = this.field_174879_c.func_177972_a(facing);
        return this.field_145850_b.func_175625_s(pos);
    }

    public ItemHandlerHamsterWheel getItemHandler() {
        return this.itemHandler;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        ++this.nbtSyncTimer;
        if (this.nbtSyncTimer > 50) {
            super.func_70296_d();
            AnimaniaHelper.sendTileEntityUpdate((TileEntity)this);
            this.nbtSyncTimer = 0;
        }
    }

    public AnimationHandler<TileEntityHamsterWheel> getAnimationHandler() {
        return animHandler;
    }

    private void updateAnims() {
        if (this.isWorldRemote()) {
            if (this.isRunning && !this.getAnimationHandler().isAnimationActive("animania", "anim_hamster_wheel", (IAnimated)this)) {
                this.getAnimationHandler().clientStartAnimation("animania", "anim_hamster_wheel", (IAnimated)this);
                this.getAnimationHandler().clientStartAnimation("animania", "hamster_run", (IAnimated)this);
            } else if (!this.isRunning && this.getAnimationHandler().isAnimationActive("animania", "anim_hamster_wheel", (IAnimated)this)) {
                this.getAnimationHandler().clientStopAnimation("animania", "anim_hamster_wheel", (IAnimated)this);
                this.getAnimationHandler().clientStopAnimation("animania", "hamster_run", (IAnimated)this);
            }
        }
    }

    static {
        animHandler.addAnim("animania", "anim_hamster_wheel", "model_hamster_wheel", true);
        animHandler.addAnim("animania", "hamster_run", "hamster", true);
    }
}

