/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.tileentities;

import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.tileentities.handler.FluidHandlerTrough;
import com.animania.common.tileentities.handler.ItemHandlerTrough;
import com.animania.config.AnimaniaConfig;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityTrough
extends TileEntity
implements ITickable {
    private TroughContent troughType;
    private int troughRotation;
    public ItemHandlerTrough itemHandler = new ItemHandlerTrough();
    public FluidHandlerTrough fluidHandler = new FluidHandlerTrough(1000);
    private int oldItemCount = 0;
    private int oldFluidCount = 0;

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        if (this.field_145854_h != null && this.field_174879_c != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145854_h.func_176223_P(), this.field_145854_h.func_176223_P(), 1);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_189515_b(tagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_73660_a() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        FluidStack fluid = this.fluidHandler.getFluid();
        if (!stack.func_190926_b()) {
            int count = stack.func_190916_E();
            if (count != this.oldItemCount) {
                this.func_70296_d();
                this.oldItemCount = count;
            }
            if (count == 0 && fluid == null && this.troughType != TroughContent.EMPTY) {
                this.setTroughType(TroughContent.EMPTY);
            } else if (count >= 1 && this.troughType != TroughContent.FOOD) {
                this.setTroughType(TroughContent.FOOD);
            }
        } else if (fluid != null) {
            if (this.troughType != TroughContent.LIQUID) {
                this.setTroughType(TroughContent.LIQUID);
            }
            if (fluid.amount != this.oldFluidCount) {
                this.func_70296_d();
                this.oldFluidCount = fluid.amount;
            }
        } else if (this.troughType != TroughContent.EMPTY) {
            this.setTroughType(TroughContent.EMPTY);
        }
    }

    public void setTroughType(TroughContent type) {
        this.troughType = type;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
    }

    public TroughContent getTroughContent() {
        return this.troughType;
    }

    public int getTroughRotation() {
        return this.troughRotation;
    }

    public void setTroughRotation(int rotation) {
        this.troughRotation = rotation;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tag = super.func_189515_b(compound);
        NBTTagCompound items = this.itemHandler.serializeNBT();
        NBTTagCompound fluid = new NBTTagCompound();
        fluid = this.fluidHandler.writeToNBT(fluid);
        tag.func_74782_a("items", (NBTBase)items);
        tag.func_74782_a("fluid", (NBTBase)fluid);
        tag.func_74774_a("Rot", (byte)(this.troughRotation & 0xFF));
        return tag;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.troughRotation = compound.func_74771_c("Rot");
        this.itemHandler = new ItemHandlerTrough();
        this.fluidHandler = new FluidHandlerTrough(1000);
        this.fluidHandler.readFromNBT(compound.func_74775_l("fluid"));
        this.itemHandler.deserializeNBT(compound.func_74775_l("items"));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (AnimaniaConfig.gameRules.allowTroughAutomation) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.fluidHandler.getFluid() == null) {
                return true;
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.itemHandler.getStackInSlot(0).func_190926_b()) {
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (AnimaniaConfig.gameRules.allowTroughAutomation) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)((Object)this.itemHandler);
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)((Object)this.fluidHandler);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        super.func_70296_d();
        AnimaniaHelper.sendTileEntityUpdate(this);
    }

    public boolean canConsume(@Nullable Set<Item> fooditems, @Nullable Fluid fluid) {
        if (fooditems != null && !this.itemHandler.getStackInSlot(0).func_190926_b()) {
            ItemStack stack = this.itemHandler.getStackInSlot(0);
            return fooditems.contains(stack.func_77973_b());
        }
        if (fluid != null && this.fluidHandler.getFluid() != null) {
            FluidStack fluidstack = this.fluidHandler.getFluid();
            return fluidstack.getFluid() == fluid;
        }
        return false;
    }

    public void consumeSolidOrLiquid(int liquidAmount, int itemAmount) {
        if (!this.itemHandler.getStackInSlot(0).func_190926_b()) {
            this.consumeSolid(itemAmount);
            return;
        }
        if (this.fluidHandler.getFluid() != null) {
            this.consumeLiquid(liquidAmount);
            return;
        }
    }

    public void consumeSolid(int amount) {
        this.itemHandler.getStackInSlot(0).func_190918_g(amount);
    }

    public void consumeLiquid(int amount) {
        this.fluidHandler.drain(amount, true);
    }

    public static enum TroughContent {
        EMPTY,
        LIQUID,
        FOOD;

    }
}

