/*
 * Decompiled with CFR 0.152.
 */
package com.animania.config;

import com.animania.common.helper.ReflectionUtil;
import com.animania.config.CommonConfig;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="animania")
public class AnimaniaConfig {
    @Config.LangKey(value="Animania")
    public static CommonConfig.Entity entity = new CommonConfig.Entity();
    public static CommonConfig.GameRules gameRules = new CommonConfig.GameRules();
    public static CommonConfig.Drops drops = new CommonConfig.Drops();
    public static CommonConfig.Spawn spawn = new CommonConfig.Spawn();
    public static CommonConfig.CareAndFeeding careAndFeeding = new CommonConfig.CareAndFeeding();
    public static CommonConfig.FoodValues foodValues = new CommonConfig.FoodValues();

    @Mod.EventBusSubscriber(modid="animania")
    public static class EventHandler {
        private static final MethodHandle CONFIGS_GETTER = ReflectionUtil.findFieldGetter(ConfigManager.class, "CONFIGS");
        private static Configuration configuration;

        public static Configuration getConfiguration() {
            if (configuration == null) {
                try {
                    String fileName = "animania.cfg";
                    Map configsMap = CONFIGS_GETTER.invokeExact();
                    Optional<Map.Entry> entryOptional = configsMap.entrySet().stream().filter(entry -> "animania.cfg".equals(new File((String)entry.getKey()).getName())).findFirst();
                    entryOptional.ifPresent(stringConfigurationEntry -> {
                        configuration = (Configuration)stringConfigurationEntry.getValue();
                    });
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            return configuration;
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("animania")) {
                ConfigManager.load((String)"animania", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

