/*
 * Decompiled with CFR 0.152.
 */
package artifacts;

import artifacts.client.render.curio.CurioLayers;
import artifacts.client.render.curio.CurioRenderers;
import artifacts.client.render.entity.MimicRenderer;
import artifacts.client.render.entity.model.MimicChestLayerModel;
import artifacts.client.render.entity.model.MimicModel;
import artifacts.common.capability.SwimHandler;
import artifacts.common.config.ModConfig;
import artifacts.common.init.ModEntityTypes;
import artifacts.common.init.ModItems;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ArtifactsClient {
    private static final ResourceLocation HELIUM_FLAMINGO_ICON = new ResourceLocation("artifacts", "textures/gui/icons.png");

    public ArtifactsClient() {
        ModConfig.registerClient();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::onClientSetup);
        modBus.addListener(this::onRegisterRenderers);
        modBus.addListener(this::onRegisterLayerDefinitions);
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        ItemProperties.register((Item)((Item)ModItems.UMBRELLA.get()), (ResourceLocation)new ResourceLocation("blocking"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        CurioRenderers.register();
        this.registerHeliumFlamingoOverlay();
    }

    public void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModEntityTypes.MIMIC, MimicRenderer::new);
    }

    public void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        CurioLayers.register(event);
        event.registerLayerDefinition(MimicModel.LAYER_LOCATION, MimicModel::createLayer);
        event.registerLayerDefinition(MimicChestLayerModel.LAYER_LOCATION, MimicChestLayerModel::createLayer);
    }

    public void registerHeliumFlamingoOverlay() {
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.AIR_LEVEL_ELEMENT, (String)"Helium Flamingo Overlay", (gui, poseStack, partialTicks, screenWidth, screenHeight) -> {
            if (!Minecraft.m_91087_().f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                gui.setupOverlayRenderState(true, false, HELIUM_FLAMINGO_ICON);
                this.renderHeliumFlamingoOverlay(screenWidth, screenHeight, poseStack, gui);
            }
        });
    }

    public void renderHeliumFlamingoOverlay(int width, int height, PoseStack poseStack, ForgeIngameGui gui) {
        Entity entity;
        Minecraft minecraft = Minecraft.m_91087_();
        if (ModConfig.server.isCosmetic((Item)ModItems.HELIUM_FLAMINGO.get()) || !((entity = minecraft.m_91288_()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity player = (LivingEntity)entity;
        player.getCapability(SwimHandler.CAPABILITY).ifPresent(handler -> {
            int left = width / 2 + 91;
            int top = height - gui.right_height;
            int swimTime = Math.abs(handler.getSwimTime());
            if (swimTime == 0) {
                return;
            }
            int maxProgressTime = handler.getSwimTime() > 0 ? ((Integer)ModConfig.server.heliumFlamingo.maxFlightTime.get()).intValue() : ((Integer)ModConfig.server.heliumFlamingo.rechargeTime.get()).intValue();
            float progress = 1.0f - (float)swimTime / (float)maxProgressTime;
            int full = Mth.m_14165_((double)(((double)progress - 2.0 / (double)maxProgressTime) * 10.0));
            int partial = Mth.m_14167_((float)(progress * 10.0f)) - full;
            for (int i = 0; i < full + partial; ++i) {
                ForgeIngameGui.m_93143_((PoseStack)poseStack, (int)(left - i * 8 - 9), (int)top, (int)-90, (float)(i < full ? 0 : 9), (float)0.0f, (int)9, (int)9, (int)16, (int)32);
            }
            gui.right_height += 10;
            RenderSystem.m_69461_();
        });
    }
}

