/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.entity;

import artifacts.common.init.ModLootTables;
import artifacts.common.init.ModSoundEvents;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class MimicEntity
extends Mob
implements Enemy {
    public int ticksInAir;
    public int attackCooldown;
    public boolean isDormant;

    public MimicEntity(EntityType<? extends MimicEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new MimicMovementController(this);
        this.f_21364_ = 10;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (this.m_21566_() instanceof MimicMovementController) {
            ((MimicMovementController)this.f_21342_).setDirection(this.f_19796_.nextInt(4) * 90, false);
        }
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 0.8).m_22268_(Attributes.f_22279_, 0.8).m_22268_(Attributes.f_22281_, 5.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FaceRandomGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new HopGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 1, true, false, entity -> !this.isDormant || (double)this.m_20270_((Entity)entity) < this.m_21051_(Attributes.f_22277_).m_22135_() / 2.5));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ticksInAir", this.ticksInAir);
        compound.m_128379_("isDormant", this.isDormant);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksInAir = compound.m_128451_("ticksInAir");
        this.isDormant = compound.m_128471_("isDormant");
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20069_()) {
            this.ticksInAir = 0;
            if (this.isDormant) {
                this.isDormant = false;
            }
        } else if (!this.f_19861_) {
            ++this.ticksInAir;
        } else if (this.ticksInAir > 0) {
            this.m_5496_(this.getLandingSound(), this.m_6121_(), this.m_6100_());
            this.ticksInAir = 0;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    public void m_6123_(Player player) {
        super.m_6123_(player);
        if (this.attackCooldown <= 0 && player.m_20193_().m_46791_() != Difficulty.PEACEFUL && this.m_20238_(player.m_142469_().m_82399_().m_82492_(0.0, this.m_142469_().m_82376_() / 2.0, 0.0)) < 1.0 && player.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_())) {
            this.attackCooldown = 20;
            this.m_19970_((LivingEntity)this, (Entity)player);
        }
    }

    public void m_6710_(LivingEntity entity) {
        this.isDormant = false;
        super.m_6710_(entity);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Player) {
            this.m_6710_((LivingEntity)source.m_7639_());
        }
        if (this.ticksInAir <= 0 && source.m_19360_() && !source.m_19376_()) {
            this.m_5496_((SoundEvent)ModSoundEvents.MIMIC_HURT.get(), this.m_6121_(), this.m_6100_());
            return false;
        }
        if (this.m_20096_() && this.m_21187_().nextBoolean() && this.m_21566_() instanceof MimicMovementController) {
            ((MimicMovementController)this.m_21566_()).setDirection(this.m_21187_().nextInt(4) * 90, true);
        }
        return super.m_6469_(source, amount);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.MIMIC_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.MIMIC_DEATH.get();
    }

    protected SoundEvent getJumpingSound() {
        return (SoundEvent)ModSoundEvents.MIMIC_OPEN.get();
    }

    protected SoundEvent getLandingSound() {
        return (SoundEvent)ModSoundEvents.MIMIC_CLOSE.get();
    }

    protected ResourceLocation m_7582_() {
        return ModLootTables.MIMIC;
    }

    public void setDormant() {
        this.isDormant = true;
    }

    protected static class MimicMovementController
    extends MoveControl {
        private final MimicEntity mimic;
        private float rotationDegrees;
        private int jumpDelay;

        public MimicMovementController(MimicEntity mimic) {
            super((Mob)mimic);
            this.mimic = mimic;
            this.rotationDegrees = 180.0f * mimic.m_146908_() / (float)Math.PI;
            this.jumpDelay = mimic.f_19796_.nextInt(320) + 640;
        }

        public void setDirection(float rotation, boolean shouldJump) {
            this.rotationDegrees = rotation;
            if (shouldJump && this.jumpDelay > 10) {
                this.jumpDelay = 10;
            }
        }

        public void setSpeed(double speed) {
            this.f_24978_ = speed;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.mimic.f_20885_ = this.mimic.f_20883_ = this.m_24991_(this.mimic.m_146908_(), this.rotationDegrees, 90.0f);
            this.mimic.m_146922_(this.mimic.f_20885_);
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.mimic.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.mimic.f_19861_) {
                    this.mimic.m_7910_((float)(this.f_24978_ * this.mimic.m_21051_(Attributes.f_22279_).m_22135_()));
                    if (this.jumpDelay-- > 0) {
                        this.mimic.f_20902_ = 0.0f;
                        this.mimic.f_20900_ = 0.0f;
                        this.mimic.m_7910_(0.0f);
                    } else {
                        this.jumpDelay = this.mimic.f_19796_.nextInt(320) + 640;
                        this.mimic.f_21343_.m_24901_();
                        this.mimic.m_5496_(this.mimic.getJumpingSound(), this.mimic.m_6121_(), this.mimic.m_6100_());
                    }
                } else {
                    this.mimic.m_7910_((float)(this.f_24978_ * this.mimic.m_21051_(Attributes.f_22279_).m_22135_()));
                }
            }
        }
    }

    protected static class FloatGoal
    extends Goal {
        private final MimicEntity mimic;

        public FloatGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            mimic.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return this.mimic.m_20069_() || this.mimic.m_20077_();
        }

        public void m_8037_() {
            if (this.mimic.m_21187_().nextFloat() < 0.8f) {
                this.mimic.f_21343_.m_24901_();
            }
            if (this.mimic.m_21566_() instanceof MimicMovementController) {
                ((MimicMovementController)this.mimic.m_21566_()).setSpeed(1.2);
            }
        }
    }

    protected static class AttackGoal
    extends Goal {
        private final MimicEntity mimic;
        private int timeRemaining;

        public AttackGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.mimic.m_5448_();
            return target instanceof Player && target.m_6084_() && target.m_20193_().m_46791_() != Difficulty.PEACEFUL && !((Player)target).m_150110_().f_35934_;
        }

        public void m_8056_() {
            this.timeRemaining = 300;
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity target = this.mimic.m_5448_();
            return target instanceof Player && target.m_6084_() && target.m_20193_().m_46791_() != Difficulty.PEACEFUL && !((Player)target).m_150110_().f_35934_ && --this.timeRemaining > 0;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.mimic.m_5448_() != null && this.mimic.m_21566_() instanceof MimicMovementController) {
                this.mimic.m_21391_((Entity)this.mimic.m_5448_(), 10.0f, 10.0f);
                ((MimicMovementController)this.mimic.m_21566_()).setDirection(this.mimic.m_146908_(), true);
            }
        }
    }

    protected static class FaceRandomGoal
    extends Goal {
        private final MimicEntity mimic;
        private int chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mimic.m_5448_() == null && (this.mimic.f_19861_ || this.mimic.m_20069_() || this.mimic.m_20077_() || this.mimic.m_21023_(MobEffects.f_19620_));
        }

        public void m_8037_() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 480 + this.mimic.m_21187_().nextInt(320);
                this.chosenDegrees = this.mimic.isDormant ? Math.round(this.mimic.m_146908_() / 90.0f) * 90 : this.mimic.m_21187_().nextInt(4) * 90;
            }
            if (this.mimic.m_21566_() instanceof MimicMovementController) {
                ((MimicMovementController)this.mimic.m_21566_()).setDirection(this.chosenDegrees, false);
            }
        }
    }

    protected static class HopGoal
    extends Goal {
        private final MimicEntity mimic;

        public HopGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.mimic.isDormant && !this.mimic.m_20159_();
        }

        public void m_8037_() {
            if (this.mimic.m_21566_() instanceof MimicMovementController) {
                ((MimicMovementController)this.mimic.m_21566_()).setSpeed(1.0);
            }
        }
    }
}

