/*
 * Decompiled with CFR 0.152.
 */
package artifacts.data;

import artifacts.common.init.ModItems;
import artifacts.common.init.ModLootTables;
import artifacts.common.loot.ConfigurableRandomChance;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public class LootTables
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = new ArrayList<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>>();
    private final ExistingFileHelper existingFileHelper;

    public LootTables(DataGenerator dataGenerator, ExistingFileHelper existingFileHelper) {
        super(dataGenerator);
        this.existingFileHelper = existingFileHelper;
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        this.tables.clear();
        this.addDrinkingHatsLootTable();
        this.addArtifactsLootTable();
        this.addChestLootTables();
        this.addLootTable("inject/entities/cow", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_6509_(ConfigurableRandomChance.configurableRandomChance(0.002f)).m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_79076_((LootPoolEntryContainer.Builder)LootTables.createItemEntry((Item)ModItems.EVERLASTING_BEEF.get(), 1).m_5577_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_())))))), LootContextParamSets.f_81415_);
        return this.tables;
    }

    private void addArtifactsLootTable() {
        this.addLootTable("artifact", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootTables.createItemEntry((Item)ModItems.SNORKEL.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.NIGHT_VISION_GOGGLES.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.PANIC_NECKLACE.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.SHOCK_PENDANT.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.FLAME_PENDANT.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.THORN_PENDANT.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.FLIPPERS.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.OBSIDIAN_SKULL.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.FIRE_GAUNTLET.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.FERAL_CLAWS.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.POCKET_PISTON.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.POWER_GLOVE.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.CROSS_NECKLACE.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.ANTIDOTE_VESSEL.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.LUCKY_SCARF.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.SUPERSTITIOUS_HAT.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.SCARF_OF_INVISIBILITY.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.DIGGING_CLAWS.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.STEADFAST_SPIKES.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.UNIVERSAL_ATTRACTOR.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.KITTY_SLIPPERS.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.RUNNING_SHOES.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.BUNNY_HOPPERS.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.CRYSTAL_HEART.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.VILLAGER_HAT.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.CLOUD_IN_A_BOTTLE.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.VAMPIRIC_GLOVE.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.GOLDEN_HOOK.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.CHARM_OF_SINKING.get(), 8)).m_79076_(LootTables.createItemEntry((Item)ModItems.AQUA_DASHERS.get(), 8)).m_79076_(LootTables.createDrinkingHatEntry(8)).m_79076_(LootTables.createItemEntry((Item)ModItems.UMBRELLA.get(), 5)).m_79076_(LootTables.createItemEntry((Item)ModItems.WHOOPEE_CUSHION.get(), 5)).m_79076_(LootTables.createItemEntry((Item)ModItems.HELIUM_FLAMINGO.get(), 4)).m_79076_(LootTables.createItemEntry((Item)ModItems.EVERLASTING_BEEF.get(), 2))));
    }

    private void addDrinkingHatsLootTable() {
        this.addLootTable("items/drinking_hat", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootTables.createItemEntry((Item)ModItems.PLASTIC_DRINKING_HAT.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.NOVELTY_DRINKING_HAT.get(), 1))));
    }

    private void addChestLootTables() {
        for (String biome : Arrays.asList("desert", "plains", "savanna", "snowy", "taiga")) {
            this.addLootTable(String.format("inject/chests/village/village_%s_house", biome), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.02f)).m_79076_(LootTables.createItemEntry((Item)ModItems.VILLAGER_HAT.get(), 1))));
        }
        this.addLootTable("inject/chests/spawn_bonus_chest", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_6509_(ConfigurableRandomChance.configurableRandomChance(1.0f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootTables.createItemEntry((Item)ModItems.WHOOPEE_CUSHION.get(), 1))));
        this.addLootTable("inject/chests/village/village_armorer", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.1f)).m_79076_(LootTables.createItemEntry((Item)ModItems.STEADFAST_SPIKES.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.SUPERSTITIOUS_HAT.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.RUNNING_SHOES.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.VAMPIRIC_GLOVE.get(), 1))));
        this.addLootTable("inject/chests/village/village_butcher", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.02f)).m_79076_(LootTables.createItemEntry((Item)ModItems.EVERLASTING_BEEF.get(), 1))));
        this.addLootTable("inject/chests/village/village_tannery", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.2f)).m_79076_(LootTables.createItemEntry((Item)ModItems.UMBRELLA.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.WHOOPEE_CUSHION.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.KITTY_SLIPPERS.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.BUNNY_HOPPERS.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.SCARF_OF_INVISIBILITY.get(), 1))));
        this.addLootTable("inject/chests/village/village_temple", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.2f)).m_79076_(LootTables.createItemEntry((Item)ModItems.CROSS_NECKLACE.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.ANTIDOTE_VESSEL.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.CHARM_OF_SINKING.get(), 1))));
        this.addLootTable("inject/chests/village/village_toolsmith", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.15f)).m_79076_(LootTables.createItemEntry((Item)ModItems.DIGGING_CLAWS.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.POCKET_PISTON.get(), 1))));
        this.addLootTable("inject/chests/village/village_weaponsmith", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.1f)).m_79076_(LootTables.createItemEntry((Item)ModItems.FERAL_CLAWS.get(), 1))));
        this.addLootTable("inject/chests/abandoned_mineshaft", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.3f)).m_79076_(LootTables.createItemEntry((Item)ModItems.NIGHT_VISION_GOGGLES.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.PANIC_NECKLACE.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.OBSIDIAN_SKULL.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.SUPERSTITIOUS_HAT.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.DIGGING_CLAWS.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.CLOUD_IN_A_BOTTLE.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.VAMPIRIC_GLOVE.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.AQUA_DASHERS.get(), 2)).m_79076_(LootTables.createDrinkingHatEntry(2))));
        this.addLootTable("inject/chests/bastion_hoglin_stable", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.2f)).m_79076_(LootTables.createArtifactEntry(5)).m_79076_(LootTables.createItemEntry((Item)ModItems.BUNNY_HOPPERS.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.FLAME_PENDANT.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.EVERLASTING_BEEF.get(), 1))));
        this.addLootTable("inject/chests/bastion_treasure", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.65f)).m_79076_(LootTables.createArtifactEntry(6)).m_79076_(LootTables.createItemEntry((Item)ModItems.GOLDEN_HOOK.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.CROSS_NECKLACE.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.FIRE_GAUNTLET.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.STEADFAST_SPIKES.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.PANIC_NECKLACE.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.CRYSTAL_HEART.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.ANTIDOTE_VESSEL.get(), 1))));
        this.addLootTable("inject/chests/buried_treasure", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.25f)).m_79076_(LootTables.createItemEntry((Item)ModItems.SNORKEL.get(), 5)).m_79076_(LootTables.createItemEntry((Item)ModItems.FLIPPERS.get(), 5)).m_79076_(LootTables.createItemEntry((Item)ModItems.UMBRELLA.get(), 5)).m_79076_(LootTables.createItemEntry((Item)ModItems.GOLDEN_HOOK.get(), 5)).m_79076_(LootTables.createItemEntry((Item)ModItems.FERAL_CLAWS.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.DIGGING_CLAWS.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.KITTY_SLIPPERS.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.BUNNY_HOPPERS.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.LUCKY_SCARF.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.AQUA_DASHERS.get(), 3)).m_79076_(LootTables.createDrinkingHatEntry(3))));
        this.addLootTable("inject/chests/desert_pyramid", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.2f)).m_79076_(LootTables.createItemEntry((Item)ModItems.FLAME_PENDANT.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.THORN_PENDANT.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.WHOOPEE_CUSHION.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.CHARM_OF_SINKING.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.SHOCK_PENDANT.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.UMBRELLA.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.SCARF_OF_INVISIBILITY.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.UNIVERSAL_ATTRACTOR.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.VAMPIRIC_GLOVE.get(), 1))));
        this.addLootTable("inject/chests/end_city_treasure", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.3f)).m_79076_(LootTables.createArtifactEntry(3)).m_79076_(LootTables.createItemEntry((Item)ModItems.CRYSTAL_HEART.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.CLOUD_IN_A_BOTTLE.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.HELIUM_FLAMINGO.get(), 4))));
        this.addLootTable("inject/chests/jungle_temple", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.3f)).m_79076_(LootTables.createItemEntry((Item)ModItems.KITTY_SLIPPERS.get(), 2)).m_79076_(LootTables.createItemEntry((Item)ModItems.BUNNY_HOPPERS.get(), 1))));
        this.addLootTable("inject/chests/nether_bridge", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.15f)).m_79076_(LootTables.createItemEntry((Item)ModItems.CROSS_NECKLACE.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.NIGHT_VISION_GOGGLES.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.POCKET_PISTON.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.RUNNING_SHOES.get(), 3)).m_79076_(LootTables.createDrinkingHatEntry(3))));
        this.addLootTable("inject/chests/pillager_outpost", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.25f)).m_79076_(LootTables.createItemEntry((Item)ModItems.PANIC_NECKLACE.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.POCKET_PISTON.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.STEADFAST_SPIKES.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.POWER_GLOVE.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.CROSS_NECKLACE.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.SCARF_OF_INVISIBILITY.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.CRYSTAL_HEART.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.CLOUD_IN_A_BOTTLE.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.SUPERSTITIOUS_HAT.get(), 1))));
        this.addLootTable("inject/chests/ruined_portal", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.15f)).m_79076_(LootTables.createItemEntry((Item)ModItems.NIGHT_VISION_GOGGLES.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.THORN_PENDANT.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.FIRE_GAUNTLET.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.POWER_GLOVE.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.UNIVERSAL_ATTRACTOR.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.OBSIDIAN_SKULL.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.LUCKY_SCARF.get(), 1))));
        this.addLootTable("inject/chests/shipwreck_treasure", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.15f)).m_79076_(LootTables.createItemEntry((Item)ModItems.GOLDEN_HOOK.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.SNORKEL.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.FLIPPERS.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.SCARF_OF_INVISIBILITY.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.STEADFAST_SPIKES.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.UNIVERSAL_ATTRACTOR.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.FERAL_CLAWS.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.NIGHT_VISION_GOGGLES.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.OBSIDIAN_SKULL.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.RUNNING_SHOES.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.CHARM_OF_SINKING.get(), 1))));
        this.addLootTable("inject/chests/stronghold_corridor", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.3f)).m_79076_(LootTables.createArtifactEntry(3)).m_79076_(LootTables.createItemEntry((Item)ModItems.POWER_GLOVE.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.ANTIDOTE_VESSEL.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.SUPERSTITIOUS_HAT.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.LUCKY_SCARF.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.AQUA_DASHERS.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.HELIUM_FLAMINGO.get(), 1))));
        this.addLootTable("inject/chests/underwater_ruin_big", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.45f)).m_79076_(LootTables.createItemEntry((Item)ModItems.SNORKEL.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.FLIPPERS.get(), 3)).m_79076_(LootTables.createItemEntry((Item)ModItems.SUPERSTITIOUS_HAT.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.LUCKY_SCARF.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.FIRE_GAUNTLET.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.CROSS_NECKLACE.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.POWER_GLOVE.get(), 1)).m_79076_(LootTables.createItemEntry((Item)ModItems.CLOUD_IN_A_BOTTLE.get(), 1))));
        this.addLootTable("inject/chests/woodland_mansion", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ConfigurableRandomChance.configurableRandomChance(0.25f)).m_79076_(LootTables.createArtifactEntry(1))));
    }

    private static LootPoolSingletonContainer.Builder<?> createItemEntry(Item item, int weight) {
        return LootItem.m_79579_((ItemLike)item).m_79707_(weight);
    }

    private static LootPoolEntryContainer.Builder<?> createArtifactEntry(int weight) {
        return LootTables.createLootTableEntry("artifact", weight);
    }

    private static LootPoolEntryContainer.Builder<?> createDrinkingHatEntry(int weight) {
        return LootTables.createLootTableEntry("items/drinking_hat", weight);
    }

    private static LootPoolEntryContainer.Builder<?> createLootTableEntry(String lootTable, int weight) {
        return LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("artifacts", lootTable)).m_79707_(weight);
    }

    private void addLootTable(String location, LootTable.Builder lootTable, LootContextParamSet lootParameterSet) {
        if (location.startsWith("inject/")) {
            String actualLocation = location.replace("inject/", "");
            Preconditions.checkArgument((boolean)this.existingFileHelper.exists(new ResourceLocation("loot_tables/" + actualLocation + ".json"), PackType.SERVER_DATA), (String)"Loot table %s does not exist in any known data pack", (Object)actualLocation);
            Preconditions.checkArgument((boolean)ModLootTables.LootTableEvents.LOOT_TABLE_LOCATIONS.contains(actualLocation), (String)"Loot table %s does not exist in list of injected loot tables", (Object)actualLocation);
        }
        this.tables.add((Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>)Pair.of(() -> lootBuilder -> lootBuilder.accept(new ResourceLocation("artifacts", location), lootTable), (Object)lootParameterSet));
    }

    private void addLootTable(String location, LootTable.Builder lootTable) {
        this.addLootTable(location, lootTable, LootContextParamSets.f_81420_);
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationTracker) {
        map.forEach((location, lootTable) -> net.minecraft.world.level.storage.loot.LootTables.m_79202_((ValidationContext)validationTracker, (ResourceLocation)location, (LootTable)lootTable));
    }
}

