/*
 * Decompiled with CFR 0.152.
 */
package artifacts;

import artifacts.compat.CompatHandler;
import artifacts.compat.HaemaCompat;
import artifacts.compat.OriginsCompat;
import artifacts.config.ModConfig;
import artifacts.init.Features;
import artifacts.init.Items;
import artifacts.init.LootTables;
import artifacts.init.ModLootConditions;
import artifacts.init.SoundEvents;
import artifacts.init.ToolHandlers;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Artifacts
implements ModInitializer {
    public static final String MOD_ID = "artifacts";
    public static final Logger LOGGER = LogManager.getLogger((String)"artifacts");
    public static final class_1761 ITEM_GROUP = FabricItemGroupBuilder.build((class_2960)Artifacts.id("item_group"), () -> new class_1799((class_1935)Items.BUNNY_HOPPERS));
    public static ModConfig CONFIG;
    private static final Map<String, Runnable> COMPAT_HANDLERS;

    public void onInitialize() {
        CONFIG = (ModConfig)AutoConfig.register(ModConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(Toml4jConfigSerializer::new)).getConfig();
        ModLootConditions.register();
        LootTableLoadingCallback.EVENT.register((resourceManager, manager, id, supplier, setter) -> LootTables.onLootTableLoad(id, supplier));
        Items.ANTIDOTE_VESSEL.toString();
        SoundEvents.MIMIC_CLOSE.toString();
        Features.register();
        for (CompatHandler handler : FabricLoader.getInstance().getEntrypoints("artifacts:compat_handlers", CompatHandler.class)) {
            if (!FabricLoader.getInstance().isModLoaded(handler.modId())) continue;
            Optional modContainer = FabricLoader.getInstance().getModContainer(handler.modId());
            String modName = modContainer.map(c -> c.getMetadata().getName()).orElse(handler.modId());
            LOGGER.info("[Artifacts] Running compat handler for " + modName);
            handler.run();
        }
        ToolHandlers.register();
        LOGGER.info("[Artifacts] Finished initialization");
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    static {
        COMPAT_HANDLERS = Map.of("origins", new OriginsCompat(), "haema", new HaemaCompat());
    }
}

