/*
 * Decompiled with CFR 0.152.
 */
package artifacts.loot;

import artifacts.Artifacts;
import artifacts.init.ModLootConditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5335;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public class ConfigurableRandomChance
implements class_5341 {
    private final float defaultProbability;

    private ConfigurableRandomChance(float defaultProbability) {
        this.defaultProbability = defaultProbability;
    }

    public class_5342 method_29325() {
        return ModLootConditions.CONFIGURABLE_ARTIFACT_CHANCE;
    }

    public boolean test(class_47 context) {
        if (Artifacts.CONFIG.worldgen.artifactRarity >= 9999.0f) {
            return false;
        }
        float c = Artifacts.CONFIG.worldgen.artifactRarity;
        float p = this.defaultProbability;
        return context.method_294().nextFloat() < p / (p + c - c * p);
    }

    public static class_5341.class_210 configurableRandomChance(float probability) {
        return () -> new ConfigurableRandomChance(probability);
    }

    public static class Serializer
    implements class_5335<ConfigurableRandomChance> {
        public void serialize(JsonObject object, ConfigurableRandomChance condition, JsonSerializationContext context) {
            object.addProperty("default_probability", (Number)Float.valueOf(condition.defaultProbability));
        }

        public ConfigurableRandomChance deserialize(JsonObject object, JsonDeserializationContext context) {
            return new ConfigurableRandomChance(class_3518.method_15259((JsonObject)object, (String)"default_probability"));
        }
    }
}

