/*
 * Decompiled with CFR 0.152.
 */
package artifacts.world;

import artifacts.Artifacts;
import artifacts.entity.MimicEntity;
import artifacts.init.Entities;
import artifacts.init.LootTables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3708;
import net.minecraft.class_3710;
import net.minecraft.class_3716;
import net.minecraft.class_3749;
import net.minecraft.class_3865;
import net.minecraft.class_3922;
import net.minecraft.class_4651;
import net.minecraft.class_4657;
import net.minecraft.class_5281;
import net.minecraft.class_5551;
import net.minecraft.class_5821;
import net.minecraft.class_6005;

public class CampsiteFeature
extends class_3031<class_3111> {
    public static final class_4651 CRAFTING_STATION_PROVIDER = new class_4657(class_6005.method_34971().method_34975((Object)class_2246.field_9980.method_9564(), 5).method_34975((Object)((class_2680)class_2246.field_10181.method_9564().method_11657((class_2769)class_3865.field_11105, (Comparable)Boolean.valueOf(false))), 5).method_34975((Object)((class_2680)class_2246.field_16333.method_9564().method_11657((class_2769)class_3710.field_11105, (Comparable)Boolean.valueOf(false))), 5).method_34975((Object)((class_2680)class_2246.field_16334.method_9564().method_11657((class_2769)class_3716.field_11105, (Comparable)Boolean.valueOf(false))), 5).method_34975((Object)class_2246.field_16329.method_9564(), 5).method_34975((Object)class_2246.field_16331.method_9564(), 5).method_34975((Object)class_2246.field_16336.method_9564(), 5).method_34975((Object)class_2246.field_10535.method_9564(), 2).method_34975((Object)class_2246.field_10105.method_9564(), 2).method_34975((Object)class_2246.field_10414.method_9564(), 1));
    public static final class_4651 DECORATION_PROVIDER = new class_4657(class_6005.method_34971().method_34975((Object)class_2246.field_16541.method_9564(), 5).method_34975((Object)class_2246.field_10336.method_9564(), 3).method_34975((Object)class_2246.field_10523.method_9564(), 3).method_34975((Object)class_2246.field_10183.method_9564(), 1).method_34975((Object)class_2246.field_10333.method_9564(), 4));
    public static final class_4651 ORE_PROVIDER = new class_4657(class_6005.method_34971().method_34975((Object)class_2246.field_10212.method_9564(), 6).method_34975((Object)class_2246.field_10080.method_9564(), 6).method_34975((Object)class_2246.field_10090.method_9564(), 6).method_34975((Object)class_2246.field_10571.method_9564(), 4).method_34975((Object)class_2246.field_10442.method_9564(), 2).method_34975((Object)class_2246.field_10013.method_9564(), 1));
    public static final class_4651 CAMPFIRE_PROVIDER = new class_4657(class_6005.method_34971().method_34975((Object)((class_2680)class_2246.field_17350.method_9564().method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false))), 12).method_34975((Object)((class_2680)class_2246.field_17350.method_9564().method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(true))), 3).method_34975((Object)((class_2680)class_2246.field_23860.method_9564().method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(true))), 1));
    public static final class_4651 LANTERN_PROVIDER = new class_4657(class_6005.method_34971().method_34975((Object)((class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.valueOf(true))), 6).method_34975((Object)((class_2680)class_2246.field_22110.method_9564().method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.valueOf(true))), 2).method_34975((Object)((class_2680)class_2246.field_10455.method_9564().method_11657((class_2769)class_5551.field_10927, (Comparable)class_2350.field_11033)), 1).method_34975((Object)class_2246.field_22122.method_9564(), 1).method_34975((Object)class_2246.field_10171.method_9564(), 1));

    public CampsiteFeature() {
        super(class_3111.field_24893);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_2338 origin = context.method_33655();
        class_5281 level = context.method_33652();
        Random random = context.method_33654();
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_2338.method_20437((class_2338)origin.method_10069(-3, 0, -3), (class_2338)origin.method_10069(3, 0, 3)).forEach(pos -> positions.add(pos.method_10062()));
        positions.remove(origin);
        positions.removeIf(currentPos -> !level.method_22347(currentPos));
        positions.removeIf(currentPos -> !level.method_8320(currentPos.method_10074()).method_26207().method_15801());
        if (positions.size() < 12) {
            return false;
        }
        Collections.shuffle(positions);
        if (random.nextInt(100) < Artifacts.CONFIG.worldgen.campsite.oreChance) {
            this.generateOreVein(level, origin.method_10074(), random);
        }
        this.generateLightSource(level, origin, random);
        this.generateContainer(level, (class_2338)positions.remove(0), random);
        if (random.nextBoolean()) {
            this.generateContainer(level, (class_2338)positions.remove(0), random);
        }
        this.generateCraftingStation(level, (class_2338)positions.remove(0), random);
        if (random.nextBoolean()) {
            this.generateCraftingStation(level, (class_2338)positions.remove(0), random);
        }
        return true;
    }

    public void generateLightSource(class_5281 world, class_2338 pos, Random random) {
        if (random.nextInt(4) != 0) {
            class_2338 currentPos = pos;
            while (currentPos.method_10264() - pos.method_10264() < 8 && world.method_22347(currentPos.method_10084())) {
                currentPos = currentPos.method_10084();
            }
            if (currentPos.method_10264() - pos.method_10264() > 2 && !world.method_22347(currentPos.method_10084())) {
                this.method_13153((class_1945)world, currentPos, LANTERN_PROVIDER.method_23455(random, currentPos));
                return;
            }
        }
        this.method_13153((class_1945)world, pos, CAMPFIRE_PROVIDER.method_23455(random, pos));
    }

    public void generateContainer(class_5281 world, class_2338 pos, Random random) {
        if (random.nextInt(100) < Artifacts.CONFIG.worldgen.campsite.mimicChance) {
            MimicEntity mimic = (MimicEntity)Entities.MIMIC.method_5883((class_1937)world.method_8410());
            if (mimic != null) {
                mimic.setDormant();
                mimic.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
                world.method_8649((class_1297)mimic);
            }
        } else {
            if (random.nextBoolean()) {
                if (random.nextInt(5) == 0) {
                    this.method_13153((class_1945)world, pos, (class_2680)class_2246.field_10380.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.class_2353.field_11062.method_10183(random)));
                    this.method_13153((class_1945)world, pos.method_10074(), class_2246.field_10375.method_9564());
                } else {
                    this.method_13153((class_1945)world, pos, (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.class_2353.field_11062.method_10183(random)));
                }
            } else {
                this.method_13153((class_1945)world, pos, (class_2680)class_2246.field_16328.method_9564().method_11657((class_2769)class_3708.field_16320, (Comparable)class_2350.method_10162((Random)random)));
            }
            class_2621.method_11287((class_1922)world, (Random)random, (class_2338)pos, (class_2960)LootTables.CAMPSITE_CHEST);
        }
    }

    public void generateCraftingStation(class_5281 world, class_2338 pos, Random random) {
        class_2680 state = CRAFTING_STATION_PROVIDER.method_23455(random, pos);
        this.method_13153((class_1945)world, pos, state);
        if (random.nextBoolean() && world.method_22347(pos.method_10084())) {
            this.generateDecoration(world, pos.method_10084(), random);
        }
    }

    public void generateDecoration(class_5281 world, class_2338 pos, Random random) {
        if (random.nextInt(3) == 0) {
            this.method_13153((class_1945)world, pos, DECORATION_PROVIDER.method_23455(random, pos));
        } else {
            this.method_13153((class_1945)world, pos, ((class_2248)class_3481.field_15470.method_15142(random)).method_9564());
        }
    }

    public void generateOreVein(class_5281 world, class_2338 pos, Random random) {
        class_2680 ore = ORE_PROVIDER.method_23455(random, pos);
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        positions.add(pos);
        for (int i = 4 + random.nextInt(12); i > 0; --i) {
            pos = (class_2338)positions.remove(0);
            this.method_13153((class_1945)world, pos, ore);
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                if (!world.method_8320(pos.method_10093(direction)).method_26207().method_15801() || world.method_8320(pos.method_10093(direction).method_10084()).method_26207().method_15801()) continue;
                positions.add(pos.method_10093(direction));
            }
            if (positions.size() != 0) continue;
            return;
        }
    }
}

