/*
 * Decompiled with CFR 0.152.
 */
package be.florens.expandability.mixin.forge.swimming;

import be.florens.expandability.EventDispatcher;
import be.florens.expandability.EventResult;
import be.florens.expandability.Util;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @ModifyExpressionValue(method={"updateSwimming", "isVisuallyCrawling"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isInFluidType(Ljava/util/function/BiPredicate;)Z")})
    private boolean setInFluidType(boolean original) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player player = (Player)entityMixin;
            return Util.processEventResult(EventDispatcher.onPlayerSwim(player), original);
        }
        return original;
    }

    @ModifyExpressionValue(method={"updateSwimming"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;canStartSwimming()Z")})
    private boolean setCanStartSwimming(boolean original) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player player = (Player)entityMixin;
            return Util.processEventResult(EventDispatcher.onPlayerSwim(player), original);
        }
        return original;
    }

    @WrapWithCondition(method={"updateInWaterStateAndDoFluidPushing"}, require=1, at={@At(value="FIELD", opcode=181, target="Lnet/minecraft/world/entity/Entity;fallDistance:F")})
    private boolean cancelFallDistanceUpdate(Entity entity, float fallDistance) {
        Player player;
        return !(entity instanceof Player) || EventDispatcher.onPlayerSwim(player = (Player)entity) != EventResult.FAIL;
    }

    @ModifyExpressionValue(method={"canSpawnSprintParticle"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isInFluidType()Z")})
    private boolean setInFluidTypeNoParams(boolean original) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player player = (Player)entityMixin;
            return Util.processEventResult(EventDispatcher.onPlayerSwim(player), original);
        }
        return original;
    }
}

