/*
 * Decompiled with CFR 0.152.
 */
package artifacts;

import artifacts.ArtifactsClient;
import artifacts.capability.SwimHandler;
import artifacts.config.ModConfig;
import artifacts.data.DataGenerators;
import artifacts.network.NetworkHandler;
import artifacts.registry.ModEntityTypes;
import artifacts.registry.ModFeatures;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import artifacts.registry.ModLootConditions;
import artifacts.registry.ModLootModifiers;
import artifacts.registry.ModPlacementModifierTypes;
import artifacts.registry.ModSoundEvents;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="artifacts")
public class Artifacts {
    public static final String MOD_ID = "artifacts";
    public static ModConfig CONFIG;

    public Artifacts() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ArtifactsClient::new);
        AutoConfig.register(ModConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> (Screen)AutoConfig.getConfigScreen(ModConfig.class, (Screen)parent).get()));
        CONFIG = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        SwimHandler.setup();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.ITEMS.register(modBus);
        ModEntityTypes.ENTITY_TYPES.register(modBus);
        ModSoundEvents.SOUND_EVENTS.register(modBus);
        ModPlacementModifierTypes.PLACEMENT_MODIFIERS.register(modBus);
        ModFeatures.FEATURES.register(modBus);
        ModLootModifiers.LOOT_MODIFIERS.register(modBus);
        ModLootConditions.LOOT_CONDITIONS.register(modBus);
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::enqueueIMC);
        modBus.addListener(ModItems::registerTab);
        modBus.addListener(DataGenerators::gatherData);
        modBus.addListener(ModEntityTypes::registerAttributes);
        MinecraftForge.EVENT_BUS.addListener(ModGameRules::onPlayerJoinWorld);
        MinecraftForge.EVENT_BUS.addListener(ModGameRules::onServerStarted);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(NetworkHandler::register);
    }

    public void enqueueIMC(InterModEnqueueEvent event) {
        SlotTypePreset[] types;
        for (SlotTypePreset type : types = new SlotTypePreset[]{SlotTypePreset.HEAD, SlotTypePreset.NECKLACE, SlotTypePreset.BELT}) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> type.getMessageBuilder().build());
        }
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HANDS.getMessageBuilder().size(2).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("feet").priority(220).icon(InventoryMenu.f_39696_).build());
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation id(String path, String ... args) {
        return new ResourceLocation(MOD_ID, String.format(path, args));
    }

    public static <T> ResourceKey<T> key(ResourceKey<? extends Registry<T>> registry, String path) {
        return ResourceKey.m_135785_(registry, (ResourceLocation)Artifacts.id(path));
    }
}

