/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client;

import artifacts.Artifacts;
import artifacts.capability.SwimHandler;
import artifacts.registry.ModGameRules;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class HeliumFlamingoOverlayRenderer {
    private static final ResourceLocation HELIUM_FLAMINGO_ICON = Artifacts.id("textures/gui/icons.png");

    public static void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (!Minecraft.m_91087_().f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            Entity entity;
            boolean isEnabled;
            Minecraft minecraft = Minecraft.m_91087_();
            boolean bl = isEnabled = ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get() > 0;
            if (isEnabled && (entity = minecraft.m_91288_()) instanceof LivingEntity) {
                LivingEntity player = (LivingEntity)entity;
                player.getCapability(SwimHandler.CAPABILITY).ifPresent(handler -> HeliumFlamingoOverlayRenderer.renderOverlay(gui, poseStack, screenWidth, screenHeight, handler.getSwimTime()));
            }
        }
    }

    private static void renderOverlay(ForgeGui gui, PoseStack poseStack, int screenWidth, int screenHeight, int swimTime) {
        gui.setupOverlayRenderState(true, false, HELIUM_FLAMINGO_ICON);
        int left = screenWidth / 2 + 91;
        int top = screenHeight - gui.rightHeight;
        if (Math.abs(swimTime) == 0) {
            return;
        }
        int maxProgressTime = swimTime > 0 ? Math.max(1, ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get() * 20) : Math.max(1, ModGameRules.HELIUM_FLAMINGO_RECHARGE_DURATION.get() * 20);
        float progress = 1.0f - (float)Math.abs(swimTime) / (float)maxProgressTime;
        int full = Mth.m_14165_((double)(((double)progress - 2.0 / (double)maxProgressTime) * 10.0));
        int partial = Mth.m_14167_((float)(progress * 10.0f)) - full;
        for (int i = 0; i < full + partial; ++i) {
            ForgeGui.m_93143_((PoseStack)poseStack, (int)(left - i * 8 - 9), (int)top, (int)-90, (float)(i < full ? 0 : 9), (float)0.0f, (int)9, (int)9, (int)32, (int)16);
        }
        gui.rightHeight += 10;
        RenderSystem.m_69461_();
    }
}

