/*
 * Decompiled with CFR 0.152.
 */
package artifacts.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="artifacts")
@Config.Gui.Background(value="minecraft:textures/block/mossy_cobblestone.png")
public class ModConfig
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.TransitiveObject
    public Common common = new Common();
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.TransitiveObject
    public Client client = new Client();

    @Config(name="common")
    public static final class Common
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=4)
        @Comment(value="Affects how common artifacts are in chests\nValues above 1 will make artifacts rarer\nValues between 0 and 1 will make artifacts more common\nSet this to 10000 to remove all artifacts from chest loot\n")
        double artifactRarity = 1.0;
        @ConfigEntry.Gui.Tooltip(count=2)
        @Comment(value="The chance everlasting beef drops when a cow\nor mooshroom is killed by a player\n")
        double everlastingBeefChance = 0.002;
        @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
        public Campsite campsite = new Campsite();

        public double getArtifactRarity() {
            return Math.max(0.0, this.artifactRarity);
        }

        public double getEverlastingBeefChance() {
            return Math.max(0.0, this.everlastingBeefChance);
        }

        public static final class Campsite
        implements ConfigData {
            @ConfigEntry.Gui.Tooltip(count=2)
            @Comment(value="How many times a campsite will attempt to generate per chunk\nSet this to 0 to prevent campsites from generating\n")
            public int count = 4;
            @ConfigEntry.Gui.Tooltip
            @Comment(value="The minimum height campsites can spawn at")
            public int minY = -60;
            @ConfigEntry.Gui.Tooltip
            @Comment(value="The maximum height campsites can spawn at")
            public int maxY = 40;
            @ConfigEntry.Gui.Tooltip
            @Comment(value="Probability that a campsite has a mimic instead of a chest")
            public double mimicChance = 0.3;
            @ConfigEntry.Gui.Tooltip
            @Comment(value="Whether to use wooden chests from other mods when generating campsites")
            public boolean useModdedChests = true;

            public int getCount() {
                return Math.max(0, this.count);
            }

            public double getMimicChance() {
                return Math.max(0.0, Math.min(1.0, this.mimicChance));
            }
        }
    }

    @Config(name="client")
    public static final class Client
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=2)
        @Comment(value="Whether the Kitty Slippers and Bunny Hoppers change the player's hurt sounds")
        public boolean modifyHurtSounds = true;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Whether models for gloves should be shown in first person")
        public boolean showFirstPersonGloves = true;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Whether artifacts should have tooltips explaining their effects")
        public boolean showTooltips = true;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Whether mimics can use textures from Lootr or Quark")
        public boolean useModdedMimicTextures = true;
    }
}

