/*
 * Decompiled with CFR 0.152.
 */
package artifacts.data;

import artifacts.data.Advancements;
import artifacts.data.BiomeModifiers;
import artifacts.data.BlockTags;
import artifacts.data.ConfiguredFeatures;
import artifacts.data.EntityTypeTags;
import artifacts.data.ItemModels;
import artifacts.data.ItemTags;
import artifacts.data.LootModifiers;
import artifacts.data.LootTables;
import artifacts.data.MobEffectTags;
import artifacts.data.PlacedFeatures;
import artifacts.data.SoundDefinitions;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class DataGenerators {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput packOutput = event.getGenerator().getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        BlockTags blockTags = new BlockTags(packOutput, lookupProvider, existingFileHelper);
        LootModifiers lootModifiers = new LootModifiers(packOutput);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTags(packOutput, lookupProvider, blockTags.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)lootModifiers);
        generator.addProvider(event.includeServer(), (DataProvider)new LootTables(packOutput, existingFileHelper, lootModifiers));
        generator.addProvider(event.includeServer(), (DataProvider)new EntityTypeTags(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MobEffectTags(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new SoundDefinitions(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new Advancements(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(generator.getPackOutput(), event.getLookupProvider(), DataGenerators.createLevelProvider(), Set.of("artifacts")));
    }

    public static RegistrySetBuilder createLevelProvider() {
        RegistrySetBuilder builder = new RegistrySetBuilder();
        builder.m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, BiomeModifiers::create);
        builder.m_254916_(Registries.f_256911_, ConfiguredFeatures::create);
        builder.m_254916_(Registries.f_256988_, PlacedFeatures::create);
        return builder;
    }
}

