/*
 * Decompiled with CFR 0.152.
 */
package artifacts.data;

import artifacts.Artifacts;
import artifacts.data.LootModifiers;
import artifacts.entity.MimicEntity;
import artifacts.loot.ConfigurableRandomChance;
import artifacts.registry.ModItems;
import artifacts.world.CampsiteFeature;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.data.ExistingFileHelper;

public class LootTables
extends LootTableProvider {
    private final List<LootTableProvider.SubProviderEntry> tables = new ArrayList<LootTableProvider.SubProviderEntry>();
    private final ExistingFileHelper existingFileHelper;
    private final LootModifiers lootModifiers;

    public LootTables(PackOutput packOutput, ExistingFileHelper existingFileHelper, LootModifiers lootModifiers) {
        super(packOutput, Set.of(), List.of());
        this.existingFileHelper = existingFileHelper;
        this.lootModifiers = lootModifiers;
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        this.tables.clear();
        this.addDrinkingHatsLootTable();
        this.addArtifactsLootTable();
        this.addChestLootTables();
        for (LootModifiers.Builder lootBuilder : this.lootModifiers.lootBuilders) {
            this.addLootTable("inject/" + lootBuilder.getName(), lootBuilder.createLootTable(), lootBuilder.getParameterSet());
        }
        this.addLootTable(MimicEntity.LOOT_TABLE.m_135815_(), new LootTable.Builder().m_79161_(new LootPool.Builder().m_79076_(LootTables.artifact(1))));
        return this.tables;
    }

    private void addArtifactsLootTable() {
        this.addLootTable("artifact", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootTables.item((Item)ModItems.SNORKEL.get(), 8)).m_79076_(LootTables.item((Item)ModItems.NIGHT_VISION_GOGGLES.get(), 8)).m_79076_(LootTables.item((Item)ModItems.PANIC_NECKLACE.get(), 8)).m_79076_(LootTables.item((Item)ModItems.SHOCK_PENDANT.get(), 8)).m_79076_(LootTables.item((Item)ModItems.FLAME_PENDANT.get(), 8)).m_79076_(LootTables.item((Item)ModItems.THORN_PENDANT.get(), 8)).m_79076_(LootTables.item((Item)ModItems.FLIPPERS.get(), 8)).m_79076_(LootTables.item((Item)ModItems.OBSIDIAN_SKULL.get(), 8)).m_79076_(LootTables.item((Item)ModItems.FIRE_GAUNTLET.get(), 8)).m_79076_(LootTables.item((Item)ModItems.FERAL_CLAWS.get(), 8)).m_79076_(LootTables.item((Item)ModItems.POCKET_PISTON.get(), 8)).m_79076_(LootTables.item((Item)ModItems.POWER_GLOVE.get(), 8)).m_79076_(LootTables.item((Item)ModItems.CROSS_NECKLACE.get(), 8)).m_79076_(LootTables.item((Item)ModItems.ANTIDOTE_VESSEL.get(), 8)).m_79076_(LootTables.item((Item)ModItems.LUCKY_SCARF.get(), 8)).m_79076_(LootTables.item((Item)ModItems.SUPERSTITIOUS_HAT.get(), 8)).m_79076_(LootTables.item((Item)ModItems.SCARF_OF_INVISIBILITY.get(), 8)).m_79076_(LootTables.item((Item)ModItems.DIGGING_CLAWS.get(), 8)).m_79076_(LootTables.item((Item)ModItems.STEADFAST_SPIKES.get(), 8)).m_79076_(LootTables.item((Item)ModItems.UNIVERSAL_ATTRACTOR.get(), 8)).m_79076_(LootTables.item((Item)ModItems.KITTY_SLIPPERS.get(), 8)).m_79076_(LootTables.item((Item)ModItems.RUNNING_SHOES.get(), 8)).m_79076_(LootTables.item((Item)ModItems.BUNNY_HOPPERS.get(), 8)).m_79076_(LootTables.item((Item)ModItems.CRYSTAL_HEART.get(), 8)).m_79076_(LootTables.item((Item)ModItems.VILLAGER_HAT.get(), 8)).m_79076_(LootTables.item((Item)ModItems.CLOUD_IN_A_BOTTLE.get(), 8)).m_79076_(LootTables.item((Item)ModItems.VAMPIRIC_GLOVE.get(), 8)).m_79076_(LootTables.item((Item)ModItems.GOLDEN_HOOK.get(), 8)).m_79076_(LootTables.item((Item)ModItems.CHARM_OF_SINKING.get(), 8)).m_79076_(LootTables.item((Item)ModItems.AQUA_DASHERS.get(), 8)).m_79076_(LootTables.drinkingHat(8)).m_79076_(LootTables.item((Item)ModItems.UMBRELLA.get(), 5)).m_79076_(LootTables.item((Item)ModItems.WHOOPEE_CUSHION.get(), 5)).m_79076_(LootTables.item((Item)ModItems.HELIUM_FLAMINGO.get(), 4)).m_79076_(LootTables.item((Item)ModItems.EVERLASTING_BEEF.get(), 2))));
    }

    private void addDrinkingHatsLootTable() {
        this.addLootTable("items/drinking_hat", LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootTables.item((Item)ModItems.PLASTIC_DRINKING_HAT.get(), 3)).m_79076_(LootTables.item((Item)ModItems.NOVELTY_DRINKING_HAT.get(), 1))));
    }

    private void addChestLootTables() {
        String barrel = CampsiteFeature.BARREL_LOOT.m_135815_();
        this.addLootTable(barrel, new LootTable.Builder().m_79161_(new LootPool.Builder().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.7f)).m_79076_((LootPoolEntryContainer.Builder)LootTables.item(Items.f_42526_, 1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)16.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootTables.item(Items.f_42527_, 1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)16.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootTables.item(Items.f_42583_, 1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)16.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootTables.item(Items.f_42500_, 1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)10.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootTables.item(Items.f_42516_, 1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)16.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootTables.item(Items.f_41909_, 1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)16.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootTables.item(Items.f_42405_, 1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)16.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootTables.item(Items.f_42517_, 1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)16.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootTables.item(Items.f_42501_, 1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)16.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootTables.item(Items.f_42413_, 1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)16.0f)))).m_79076_(LootTables.lootTable(barrel + "/tnt", 1)).m_79076_(LootTables.lootTable(barrel + "/cobwebs", 1)).m_79076_(LootTables.lootTable(barrel + "/ores", 1)).m_79076_(LootTables.lootTable(barrel + "/ingots", 1)).m_79076_(LootTables.lootTable(barrel + "/gems", 1)).m_79076_(LootTables.lootTable(barrel + "/crops", 1)).m_79076_(LootTables.lootTable(barrel + "/food", 1)).m_79076_(LootTables.lootTable(barrel + "/cobblestone", 1)).m_79076_(LootTables.lootTable(barrel + "/rails", 1)).m_79076_(LootTables.lootTable(barrel + "/minecarts", 1))));
        this.addLootTable(barrel + "/tnt", new LootTable.Builder().m_79161_(new LootPool.Builder().name("tnt").m_165133_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79076_(LootTables.item(Items.f_41996_, 1)).m_79076_(LootTables.item(Items.f_42403_, 4, 1, 5))).m_79161_(new LootPool.Builder().name("sand").m_79076_(LootTables.item(Items.f_41830_, 2, 8, 40)).m_79076_(LootTables.item(Items.f_41831_, 1, 8, 40))));
        this.addLootTable(barrel + "/cobwebs", new LootTable.Builder().m_79161_(new LootPool.Builder().m_79076_(LootTables.item(Items.f_41863_, 1, 3, 8))).m_79161_(new LootPool.Builder().m_79076_(LootTables.item(Items.f_42401_, 1, 6, 16))));
        this.addLootTable(barrel + "/ores", new LootTable.Builder().m_79161_(new LootPool.Builder().name("ores").m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_(LootTables.item(Items.f_151053_, 1, 4, 20)).m_79076_(LootTables.item(Items.f_151050_, 1, 4, 20)).m_79076_(LootTables.item(Items.f_151051_, 1, 4, 20))).m_79161_(new LootPool.Builder().name("blocks").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootTables.item(Items.f_150997_, 1, 2, 8)).m_79076_(LootTables.item(Items.f_150995_, 1, 2, 8)).m_79076_(LootTables.item(Items.f_150996_, 1, 2, 8))));
        this.addLootTable(barrel + "/ingots", new LootTable.Builder().m_79161_(new LootPool.Builder().name("ingots").m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_(LootTables.item(Items.f_42417_, 1, 4, 16)).m_79076_(LootTables.item(Items.f_42416_, 1, 4, 16)).m_79076_(LootTables.item(Items.f_151052_, 1, 4, 16))).m_79161_(new LootPool.Builder().name("blocks").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootTables.item(Items.f_41912_, 1, 1, 6)).m_79076_(LootTables.item(Items.f_41913_, 1, 1, 6)).m_79076_(LootTables.item(Items.f_151000_, 1, 4, 16))));
        this.addLootTable(barrel + "/gems", new LootTable.Builder().m_79161_(new LootPool.Builder().m_165133_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79076_(LootTables.item(Items.f_151049_, 3, 1, 8)).m_79076_(LootTables.item(Items.f_42415_, 1, 1, 4)).m_79076_(LootTables.item(Items.f_42616_, 1, 1, 4))));
        this.addLootTable(barrel + "/crops", new LootTable.Builder().m_79161_(new LootPool.Builder().m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_(LootTables.item(Items.f_42620_, 1, 2, 12)).m_79076_(LootTables.item(Items.f_42619_, 1, 2, 12)).m_79076_(LootTables.item(Items.f_42732_, 1, 2, 12)).m_79076_(LootTables.item(Items.f_42405_, 1, 2, 12)).m_79076_(LootTables.item(Items.f_42575_, 1, 2, 12)).m_79076_(LootTables.item(Items.f_42046_, 1, 2, 12)).m_79076_(LootTables.item(Items.f_42410_, 1, 2, 12))));
        this.addLootTable(barrel + "/food", new LootTable.Builder().m_79161_(new LootPool.Builder().m_165133_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79076_(LootTables.item(Items.f_42406_, 1, 2, 12)).m_79076_(LootTables.item(Items.f_42687_, 1, 2, 12)).m_79076_(LootTables.item(Items.f_42502_, 1)).m_79076_(LootTables.item(Items.f_42572_, 1, 2, 12)).m_79076_(LootTables.item(Items.f_42400_, 1, 1, 4)).m_79076_(LootTables.item(Items.f_42699_, 1, 1, 4))));
        this.addLootTable(barrel + "/cobblestone", new LootTable.Builder().m_79161_(new LootPool.Builder().m_165133_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79076_(LootTables.item(Items.f_42594_, 1, 16, 64)).m_79076_(LootTables.item(Items.f_151035_, 1, 16, 64))));
        this.addLootTable(barrel + "/rails", new LootTable.Builder().m_79161_(new LootPool.Builder().m_165133_((NumberProvider)ConstantValue.m_165692_((float)4.0f)).m_79076_(LootTables.item(Items.f_41964_, 4, 4, 16)).m_79076_(LootTables.item(Items.f_42161_, 1, 2, 5)).m_79076_(LootTables.item(Items.f_41861_, 1, 2, 5)).m_79076_(LootTables.item(Items.f_41860_, 2, 4, 16))));
        this.addLootTable(barrel + "/minecarts", new LootTable.Builder().m_79161_(new LootPool.Builder().name("minecarts").m_165133_((NumberProvider)ConstantValue.m_165692_((float)5.0f)).m_79076_(LootTables.item(Items.f_42449_, 4)).m_79076_(LootTables.item(Items.f_42519_, 1)).m_79076_(LootTables.item(Items.f_42520_, 1)).m_79076_(LootTables.item(Items.f_42694_, 1))).m_79161_(new LootPool.Builder().name("rails").m_79076_(LootTables.item(Items.f_41964_, 1, 4, 16))));
        this.addLootTable(CampsiteFeature.CHEST_LOOT.m_135815_(), new LootTable.Builder().m_79161_(new LootPool.Builder().name("tools").m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)).m_79076_(LootTables.item(Items.f_42390_, 2)).m_79076_(LootTables.item(Items.f_42391_, 1)).m_79076_(LootTables.item(Items.f_42389_, 1)).m_79076_(LootTables.item(Items.f_42432_, 4)).m_79076_(LootTables.item(Items.f_42433_, 2)).m_79076_(LootTables.item(Items.f_42431_, 2)).m_79076_(LootTables.item(Items.f_42385_, 6)).m_79076_(LootTables.item(Items.f_42386_, 3)).m_79076_(LootTables.item(Items.f_42384_, 3)).m_79076_(LootTables.item(Items.f_42468_, 2)).m_79076_(LootTables.item(Items.f_42469_, 2)).m_79076_(LootTables.item(Items.f_42470_, 2)).m_79076_(LootTables.item(Items.f_42471_, 2)).m_79076_(LootTables.item(Items.f_42464_, 1)).m_79076_(LootTables.item(Items.f_42465_, 1)).m_79076_(LootTables.item(Items.f_42466_, 1)).m_79076_(LootTables.item(Items.f_42467_, 1))).m_79161_(new LootPool.Builder().name("junk").m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)).m_79076_(LootTables.item(Items.f_42403_, 5, 2, 8)).m_79076_(LootTables.item(Items.f_42583_, 5, 2, 8)).m_79076_(LootTables.item(Items.f_42591_, 5, 2, 8)).m_79076_(LootTables.item(Items.f_42401_, 5, 2, 8)).m_79076_(LootTables.item(Items.f_42516_, 5, 2, 8)).m_79076_(LootTables.item(Items.f_42500_, 5, 2, 8)).m_79076_(LootTables.item(Items.f_42398_, 3, 2, 8)).m_79076_(LootTables.item(Items.f_42590_, 3, 2, 8)).m_79076_(LootTables.item(Items.f_42454_, 3, 2, 8)).m_79076_(LootTables.item(Items.f_42484_, 3, 2, 8)).m_79076_(LootTables.item(Items.f_42402_, 3, 2, 8))).m_79161_(new LootPool.Builder().name("ores").m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)).m_79076_(LootTables.item(Items.f_151051_, 3, 2, 8)).m_79076_(LootTables.item(Items.f_151050_, 3, 2, 8)).m_79076_(LootTables.item(Items.f_151053_, 3, 2, 8)).m_79076_(LootTables.item(Items.f_42413_, 6, 4, 8)).m_79076_(LootTables.item(Items.f_42415_, 1, 1, 4))).m_79161_(new LootPool.Builder().name("treasure").m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.3f)).m_79076_((LootPoolEntryContainer.Builder)LootTables.item(Items.f_42517_, 8).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)15.0f, (float)30.0f)).m_80499_())).m_79076_(LootTables.item(Items.f_42436_, 4)).m_79076_(LootTables.item(Items.f_42437_, 1))).m_79161_(new LootPool.Builder().name("artifact").m_79080_(ConfigurableRandomChance.configurableRandomChance(0.15f)).m_79076_(LootTables.artifact(1))));
    }

    protected static LootPoolSingletonContainer.Builder<?> item(Item item, int weight) {
        return LootItem.m_79579_((ItemLike)item).m_79707_(weight);
    }

    protected static LootPoolSingletonContainer.Builder<?> item(Item item, int weight, int min, int max) {
        return LootItem.m_79579_((ItemLike)item).m_79707_(weight).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
    }

    protected static LootPoolEntryContainer.Builder<?> artifact(int weight) {
        return LootTables.lootTable("artifact", weight);
    }

    protected static LootPoolEntryContainer.Builder<?> drinkingHat(int weight) {
        return LootTables.lootTable("items/drinking_hat", weight);
    }

    private static LootPoolEntryContainer.Builder<?> lootTable(String lootTable, int weight) {
        return LootTableReference.m_79776_((ResourceLocation)Artifacts.id(lootTable)).m_79707_(weight);
    }

    private void addLootTable(String location, LootTable.Builder lootTable, LootContextParamSet lootParameterSet) {
        if (location.startsWith("inject/")) {
            String actualLocation = location.replace("inject/", "");
            Preconditions.checkArgument((boolean)this.existingFileHelper.exists(new ResourceLocation("loot_tables/" + actualLocation + ".json"), PackType.SERVER_DATA), (String)"Loot table %s does not exist in any known data pack", (Object)actualLocation);
        }
        this.tables.add(new LootTableProvider.SubProviderEntry(() -> lootBuilder -> lootBuilder.accept(Artifacts.id(location), lootTable), lootParameterSet));
    }

    private void addLootTable(String location, LootTable.Builder lootTable) {
        this.addLootTable(location, lootTable, LootContextParamSets.f_81420_);
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationTracker) {
        map.forEach((location, lootTable) -> net.minecraft.world.level.storage.loot.LootTables.m_79202_((ValidationContext)validationTracker, (ResourceLocation)location, (LootTable)lootTable));
    }
}

