/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item;

import artifacts.Artifacts;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ArtifactItem
extends Item {
    public ArtifactItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.RARE).m_41486_());
    }

    public ArtifactItem() {
        this(new Item.Properties());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != Enchantments.f_44962_ && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        if (Artifacts.CONFIG.client.showTooltips) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            this.addTooltip(tooltip);
            tooltip.forEach(line -> tooltipList.add((Component)line.m_130940_(ChatFormatting.GRAY)));
        }
    }

    protected void addTooltip(List<MutableComponent> tooltip) {
        if (this.isCosmetic()) {
            tooltip.add(Component.m_237115_((String)"%s.tooltip.cosmetic".formatted("artifacts")).m_130940_(ChatFormatting.ITALIC));
        } else {
            this.addEffectsTooltip(tooltip);
        }
    }

    protected void addEffectsTooltip(List<MutableComponent> tooltip) {
        tooltip.add(Component.m_237115_((String)"%s.tooltip.item.%s".formatted("artifacts", this.getTooltipItemName())));
    }

    protected MutableComponent tooltipLine(String lineId, Object ... args) {
        return Component.m_237110_((String)"%s.tooltip.item.%s.%s".formatted("artifacts", this.getTooltipItemName(), lineId), (Object[])args);
    }

    protected String getTooltipItemName() {
        return ForgeRegistries.ITEMS.getKey((Object)this).m_135815_();
    }

    protected abstract boolean isCosmetic();
}

