/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable;

import artifacts.item.wearable.WearableArtifactItem;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;

public class MobEffectItem
extends WearableArtifactItem {
    private final MobEffect mobEffect;
    private final int duration;
    protected final Supplier<Integer> amplifier;
    protected final Supplier<Boolean> isEnabled;

    public MobEffectItem(MobEffect mobEffect, Supplier<Boolean> isEnabled) {
        this(mobEffect, () -> 1, 40, isEnabled);
    }

    public MobEffectItem(MobEffect mobEffect, int duration, Supplier<Boolean> isEnabled) {
        this(mobEffect, () -> 1, duration, isEnabled);
    }

    public MobEffectItem(MobEffect mobEffect, Supplier<Integer> amplifier, int duration) {
        this(mobEffect, amplifier, duration, () -> true);
    }

    private MobEffectItem(MobEffect mobEffect, Supplier<Integer> amplifier, int duration, Supplier<Boolean> isEnabled) {
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.isEnabled = isEnabled;
    }

    @Override
    protected boolean isCosmetic() {
        return this.isEnabled.get() == false || this.amplifier.get() <= 0;
    }

    public boolean isEffectActive(LivingEntity entity) {
        if (!this.isEnabled.get().booleanValue() || this.amplifier.get() <= 0) {
            return false;
        }
        Optional curio = CuriosApi.getCuriosHelper().findFirstCurio(entity, (Item)this);
        return curio.isPresent() && MobEffectItem.isActivated(((SlotResult)curio.get()).stack());
    }

    private int getAmplifier() {
        return Math.max(0, Math.min(127, this.amplifier.get() - 1));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (this.isEffectActive(slotContext.entity()) && !slotContext.entity().f_19853_.m_5776_()) {
            slotContext.entity().m_7292_(new MobEffectInstance(this.mobEffect, this.duration - 1, this.getAmplifier(), true, false));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        MobEffectInstance effectInstance;
        if (this.isEnabled.get().booleanValue() && !slotContext.entity().f_19853_.m_5776_() && (effectInstance = slotContext.entity().m_21124_(this.mobEffect)) != null && effectInstance.m_19564_() == this.getAmplifier() && !effectInstance.m_19572_() && effectInstance.m_19557_() < this.duration) {
            slotContext.entity().m_21195_(this.mobEffect);
        }
    }
}

