/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.belt;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import top.theillusivec4.curios.api.SlotContext;

public class UniversalAttractorItem
extends WearableArtifactItem {
    public UniversalAttractorItem() {
        MinecraftForge.EVENT_BUS.addListener(this::onItemToss);
    }

    @Override
    protected boolean isCosmetic() {
        return ModGameRules.UNIVERSAL_ATTRACTOR_ENABLED.get() == false;
    }

    private void onItemToss(ItemTossEvent event) {
        if (ModGameRules.UNIVERSAL_ATTRACTOR_ENABLED.get().booleanValue()) {
            event.getPlayer().m_36335_().m_41524_((Item)this, 100);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity;
        if (!ModGameRules.UNIVERSAL_ATTRACTOR_ENABLED.get().booleanValue() || !((livingEntity = slotContext.entity()) instanceof Player) || (player = (Player)livingEntity).m_5833_() || player.m_36335_().m_41519_((Item)this) || !UniversalAttractorItem.isActivated(stack)) {
            return;
        }
        Vec3 playerPos = player.m_20182_().m_82520_(0.0, 0.75, 0.0);
        int range = 5;
        List items = player.f_19853_.m_45976_(ItemEntity.class, new AABB(playerPos.f_82479_ - (double)range, playerPos.f_82480_ - (double)range, playerPos.f_82481_ - (double)range, playerPos.f_82479_ + (double)range, playerPos.f_82480_ + (double)range, playerPos.f_82481_ + (double)range));
        int pulled = 0;
        for (ItemEntity item : items) {
            if (!item.m_6084_() || item.m_32063_() || item.getPersistentData().m_128471_("PreventRemoteMovement")) continue;
            if (pulled++ > 200) break;
            Vec3 motion = playerPos.m_82546_(item.m_20182_().m_82520_(0.0, (double)(item.m_20206_() / 2.0f), 0.0));
            if (Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82480_ * motion.f_82480_ + motion.f_82481_ * motion.f_82481_) > 1.0) {
                motion = motion.m_82541_();
            }
            item.m_20256_(motion.m_82490_(0.6));
        }
    }
}

