/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.feet;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModTags;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class KittySlippersItem
extends WearableArtifactItem {
    public KittySlippersItem() {
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
        this.addListener(LivingChangeTargetEvent.class, this::onLivingChangeTargetEvent, LivingChangeTargetEvent::getNewTarget);
        this.addListener(LivingEvent.LivingTickEvent.class, this::onLivingUpdate, (T event) -> event.getEntity().m_21188_());
    }

    @Override
    protected boolean isCosmetic() {
        return ModGameRules.KITTY_SLIPPERS_ENABLED.get() == false;
    }

    private void onEntityJoinWorld(EntityJoinLevelEvent event) {
        PathfinderMob creeper;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof PathfinderMob && (creeper = (PathfinderMob)entity2).m_6095_().m_204039_(ModTags.CREEPERS)) {
            creeper.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal(creeper, Player.class, entity -> entity != null && ModGameRules.KITTY_SLIPPERS_ENABLED.get() != false && this.isEquippedBy((LivingEntity)entity), 6.0f, 1.0, 1.3, EntitySelector.f_20406_::test));
        }
    }

    private void onLivingChangeTargetEvent(LivingChangeTargetEvent event, LivingEntity wearer) {
        Mob creeper;
        LivingEntity livingEntity;
        if (ModGameRules.KITTY_SLIPPERS_ENABLED.get().booleanValue() && (livingEntity = event.getEntity()) instanceof Mob && (creeper = (Mob)livingEntity).m_6095_().m_204039_(ModTags.CREEPERS)) {
            event.setCanceled(true);
        }
    }

    private void onLivingUpdate(LivingEvent.LivingTickEvent event, LivingEntity wearer) {
        if (ModGameRules.KITTY_SLIPPERS_ENABLED.get().booleanValue() && event.getEntity().m_6095_().m_204039_(ModTags.CREEPERS)) {
            event.getEntity().m_6703_(null);
        }
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11785_, 1.0f, 1.0f);
    }
}

