/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.head;

import artifacts.item.wearable.WearableArtifactItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class DrinkingHatItem
extends WearableArtifactItem {
    private final Supplier<Integer> drinkingDurationMultiplier;
    private final Supplier<Integer> eatingDurationMultiplier;
    private final boolean hasSpecialTooltip;

    public DrinkingHatItem(Supplier<Integer> drinkingDurationMultiplier, Supplier<Integer> eatingDurationMultiplier, boolean hasSpecialTooltip) {
        this.addListener(LivingEntityUseItemEvent.Start.class, this::onItemUseStart);
        this.drinkingDurationMultiplier = drinkingDurationMultiplier;
        this.eatingDurationMultiplier = eatingDurationMultiplier;
        this.hasSpecialTooltip = hasSpecialTooltip;
    }

    @Override
    protected boolean isCosmetic() {
        return this.drinkingDurationMultiplier.get() >= 100 && this.eatingDurationMultiplier.get() >= 100;
    }

    @Override
    protected void addTooltip(List<MutableComponent> tooltip) {
        if (this.hasSpecialTooltip) {
            tooltip.add(this.tooltipLine("special", new Object[0]).m_130940_(ChatFormatting.ITALIC));
            this.addEffectsTooltip(tooltip);
        } else {
            super.addTooltip(tooltip);
        }
    }

    @Override
    protected void addEffectsTooltip(List<MutableComponent> tooltip) {
        if (this.drinkingDurationMultiplier.get() < 100) {
            tooltip.add(this.tooltipLine("drinking", new Object[0]));
        }
        if (this.eatingDurationMultiplier.get() < 100) {
            tooltip.add(this.tooltipLine("eating", new Object[0]));
        }
    }

    @Override
    protected String getTooltipItemName() {
        return "drinking_hat";
    }

    private void onItemUseStart(LivingEntityUseItemEvent.Start event, LivingEntity wearer) {
        UseAnim action = event.getItem().m_41780_();
        if (action != UseAnim.EAT && action != UseAnim.DRINK) {
            return;
        }
        int newDuration = (int)((double)event.getDuration() * Math.min(1.0, Math.max(0.0, this.getDurationMultiplier(this, action))));
        event.setDuration(Math.max(1, newDuration));
    }

    private double getDurationMultiplier(Item drinkingHat, UseAnim action) {
        if (action == UseAnim.DRINK) {
            return (double)this.drinkingDurationMultiplier.get().intValue() / 100.0;
        }
        return (double)this.eatingDurationMultiplier.get().intValue() / 100.0;
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11770_, 1.0f, 1.0f);
    }
}

