/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.necklace;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.util.DamageSourceHelper;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public abstract class PendantItem
extends WearableArtifactItem {
    private final Supplier<Integer> strikeChance;

    public PendantItem(Supplier<Integer> strikeChance) {
        this.addListener(LivingAttackEvent.class, this::onLivingAttack);
        this.strikeChance = strikeChance;
    }

    private void onLivingAttack(LivingAttackEvent event, LivingEntity wearer) {
        LivingEntity attacker = DamageSourceHelper.getAttacker(event.getSource());
        if (!wearer.f_19853_.m_5776_() && event.getAmount() >= 1.0f && attacker != null && wearer.m_217043_().m_188500_() < (double)this.strikeChance.get().intValue() / 100.0) {
            this.applyEffect(wearer, attacker);
        }
    }

    protected abstract void applyEffect(LivingEntity var1, LivingEntity var2);

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11673_, 1.0f, 1.0f);
    }
}

