/*
 * Decompiled with CFR 0.152.
 */
package artifacts.network;

import artifacts.capability.SwimHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SwimPacket {
    private final boolean shouldSwim;

    public SwimPacket(FriendlyByteBuf buffer) {
        this.shouldSwim = buffer.readBoolean();
    }

    public SwimPacket(boolean shouldSwim) {
        this.shouldSwim = shouldSwim;
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.shouldSwim);
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        if (player != null) {
            context.get().enqueueWork(() -> this.lambda$handle$1((Player)player));
        }
        context.get().setPacketHandled(true);
    }

    private /* synthetic */ void lambda$handle$1(Player player) {
        player.getCapability(SwimHandler.CAPABILITY).ifPresent(handler -> handler.setSwimming(this.shouldSwim));
    }
}

