/*
 * Decompiled with CFR 0.152.
 */
package be.florens.expandability.mixin.swimming;

import be.florens.expandability.EventDispatcher;
import be.florens.expandability.EventResult;
import be.florens.expandability.Util;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public Level f_19853_;

    @Shadow
    public abstract boolean m_20069_();

    @ModifyExpressionValue(method={"updateSwimming", "isVisuallyCrawling", "canSpawnSprintParticle", "move"}, require=4, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isInWater()Z")})
    private boolean setInWater(boolean original) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player player = (Player)entityMixin;
            return Util.processEventResult(EventDispatcher.onPlayerSwim(player), original);
        }
        return original;
    }

    @ModifyExpressionValue(method={"updateSwimming"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isUnderWater()Z")})
    private boolean setUnderWater(boolean original) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player player = (Player)entityMixin;
            return Util.processEventResult(EventDispatcher.onPlayerSwim(player), original);
        }
        return original;
    }

    @WrapWithCondition(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;playSwimSound(F)V")})
    private boolean cancelPlaySwimSound(Entity entity, float volume) {
        Player player;
        return this.m_20069_() || !(entity instanceof Player) || EventDispatcher.onPlayerSwim(player = (Player)entity) != EventResult.SUCCESS;
    }

    @WrapWithCondition(method={"updateInWaterStateAndDoWaterCurrentPushing", "move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;resetFallDistance()V")})
    private boolean cancelResetFallDistance(Entity entity) {
        Player player;
        return !(entity instanceof Player) || EventDispatcher.onPlayerSwim(player = (Player)entity) != EventResult.FAIL;
    }

    @ModifyExpressionValue(method={"getBlockSpeedFactor"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/world/level/block/Block;)Z")})
    private boolean fixBlockSpeedFactor(boolean original) {
        Player player;
        BlockState block;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && (block = player.f_19853_.m_8055_((player = (Player)entityMixin).m_20183_())).m_60713_(Blocks.f_49990_) && EventDispatcher.onPlayerSwim(player) == EventResult.FAIL) {
            return true;
        }
        return original;
    }
}

