/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.trinkets;

import artifacts.common.item.curio.CurioItem;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3545;

public final class TrinketsHelper {
    private TrinketsHelper() {
    }

    public static boolean isEquipped(class_1792 item, class_1309 entity) {
        return TrinketsHelper.isEquipped(item, entity, false);
    }

    public static boolean isEquipped(Predicate<class_1799> filter, class_1309 entity) {
        return TrinketsHelper.isEquipped(filter, entity, false);
    }

    public static List<class_1799> getAllEquipped(class_1309 entity) {
        return TrinketsHelper.getAllEquipped(entity, false);
    }

    public static boolean isEquipped(class_1792 item, class_1309 entity, boolean ignoreEffectsDisabled) {
        return TrinketsHelper.isEquipped((class_1799 stack) -> stack.method_7909().equals(item), entity, ignoreEffectsDisabled);
    }

    public static boolean isEquipped(Predicate<class_1799> filter, class_1309 entity, boolean ignoreEffectsDisabled) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).map(comp -> comp.isEquipped(stack -> (TrinketsHelper.areEffectsEnabled(stack) || ignoreEffectsDisabled) && filter.test((class_1799)stack))).orElse(false);
    }

    public static List<class_1799> getAllEquipped(class_1309 entity, boolean ignoreEffectsDisabled) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).stream().flatMap(comp -> comp.getAllEquipped().stream()).map(class_3545::method_15441).filter(stack -> !stack.method_7960() && stack.method_7909() instanceof CurioItem && (TrinketsHelper.areEffectsEnabled(stack) || ignoreEffectsDisabled)).collect(Collectors.toList());
    }

    public static boolean areEffectsEnabled(class_1799 stack) {
        return CurioItem.getArtifactStatus(stack).map(CurioItem.ArtifactStatus::hasEffects).orElse(false);
    }

    public static boolean areCosmetisEnabled(class_1799 stack) {
        return CurioItem.getArtifactStatus(stack).map(CurioItem.ArtifactStatus::hasCosmetics).orElse(false);
    }

    public static List<class_1799> getAllEquippedForSlot(class_1309 entity, String groupId, String slotId) {
        return TrinketsHelper.getAllEquippedForSlot(entity, groupId, slotId, false);
    }

    public static List<class_1799> getAllEquippedForSlot(class_1309 entity, String groupId, String slotId, boolean ignoreEffectsDisabled) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).map(TrinketComponent::getInventory).flatMap(invByGroup -> Optional.ofNullable((Map)invByGroup.get(groupId))).flatMap(invBySlot -> Optional.ofNullable((TrinketInventory)invBySlot.get(slotId))).stream().flatMap(inv -> IntStream.range(0, inv.method_5439()).mapToObj(arg_0 -> ((TrinketInventory)inv).method_5438(arg_0))).filter(stack -> stack.method_7909() instanceof CurioItem && (TrinketsHelper.areEffectsEnabled(stack) || ignoreEffectsDisabled)).collect(Collectors.toList());
    }
}

