/*
 * Decompiled with CFR 0.152.
 */
package artifacts.fabric.platform;

import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.component.SwimData;
import artifacts.fabric.client.CosmeticsHelper;
import artifacts.fabric.registry.ModComponents;
import artifacts.fabric.trinket.TrinketsHelper;
import artifacts.item.wearable.WearableArtifactItem;
import artifacts.platform.PlatformHelper;
import dev.emi.stepheightentityattribute.StepHeightEntityAttributeMain;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import io.github.fabricators_of_create.porting_lib.attributes.PortingLibAttributes;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import org.jetbrains.annotations.Nullable;

public class FabricPlatformHelper
implements PlatformHelper {
    @Override
    public boolean isEquippedBy(@Nullable class_1309 entity, class_1792 item) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).map(component -> component.isEquipped(item)).orElse(false);
    }

    @Override
    public Stream<class_1799> findAllEquippedBy(class_1309 entity, class_1792 item) {
        return TrinketsHelper.findAllEquippedBy(entity).filter(stack -> stack.method_7909() == item);
    }

    @Override
    public class_1320 getStepHeightAttribute() {
        return StepHeightEntityAttributeMain.STEP_HEIGHT;
    }

    @Override
    public class_1320 getSwimSpeedAttribute() {
        return PortingLibAttributes.SWIM_SPEED;
    }

    @Override
    public class_1320 getEntityGravityAttribute() {
        return PortingLibAttributes.ENTITY_GRAVITY;
    }

    @Override
    public boolean isCorrectTierForDrops(class_1832 tier, class_2680 state) {
        int i = tier.method_8024();
        if (i < 3 && state.method_26164(class_3481.field_33717)) {
            return false;
        }
        if (i < 2 && state.method_26164(class_3481.field_33718)) {
            return false;
        }
        return i >= 1 || !state.method_26164(class_3481.field_33719);
    }

    @Override
    @Nullable
    public SwimData getSwimData(class_1309 player) {
        return (SwimData)ModComponents.SWIM_DATA.getNullable((Object)player);
    }

    @Override
    public boolean isEyeInWater(class_1657 player) {
        return player.method_5777(class_3486.field_15517);
    }

    @Override
    public void registerArtifactRenderer(WearableArtifactItem item, Supplier<ArtifactRenderer> rendererSupplier) {
        TrinketRendererRegistry.registerRenderer((class_1792)item, (TrinketRenderer)new ArtifactTrinketRenderer(rendererSupplier.get()));
    }

    @Override
    @Nullable
    public ArtifactRenderer getArtifactRenderer(class_1792 item) {
        Object t;
        Optional renderer = TrinketRendererRegistry.getRenderer((class_1792)item);
        if (renderer.isPresent() && (t = renderer.get()) instanceof ArtifactTrinketRenderer) {
            ArtifactTrinketRenderer artifactTrinketRenderer = (ArtifactTrinketRenderer)t;
            return artifactTrinketRenderer.renderer();
        }
        return null;
    }

    private record ArtifactTrinketRenderer(ArtifactRenderer renderer) implements TrinketRenderer
    {
        public void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_1309> entityModel, class_4587 poseStack, class_4597 multiBufferSource, int light, class_1309 entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (CosmeticsHelper.isCosmeticsDisabled(stack)) {
                return;
            }
            int index = slotReference.index() + (slotReference.inventory().getSlotType().getGroup().equals("hand") ? 0 : 1);
            this.renderer.render(stack, entity, index, poseStack, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

