/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.necklace;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.util.DamageSourceHelper;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public abstract class PendantItem
extends WearableArtifactItem {
    private final Supplier<Integer> strikeChance;
    private final Supplier<Integer> cooldown;

    public PendantItem(Supplier<Integer> strikeChance, Supplier<Integer> cooldown) {
        EntityEvent.LIVING_HURT.register(this::onLivingHurt);
        this.strikeChance = strikeChance;
        this.cooldown = cooldown;
    }

    protected EventResult onLivingHurt(class_1309 entity, class_1282 damageSource, float amount) {
        class_1309 attacker = DamageSourceHelper.getAttacker(damageSource);
        if (this.isEquippedBy(entity) && !entity.method_37908().method_8608() && amount >= 1.0f && attacker != null && !this.isOnCooldown(entity) && entity.method_6051().method_43058() < (double)this.strikeChance.get().intValue() / 100.0) {
            this.applyEffect(entity, attacker);
            this.addCooldown(entity, this.cooldown.get());
        }
        return EventResult.pass();
    }

    protected abstract void applyEffect(class_1309 var1, class_1309 var2);

    @Override
    public class_3414 getEquipSound() {
        return class_3417.field_15103;
    }
}

